package csl.tools.collections;

import java.util.Stack;

public class FixedSizeStack<E> extends Stack<E> {

	private static final long serialVersionUID = 1829903390914247646L;

	public final int maxSize;
	public final boolean shiftable;

	public FixedSizeStack(int maxSize, boolean shiftable) {
		super();
		this.maxSize = maxSize;
		this.shiftable = shiftable;
	}

	public E push(E item) {
		if (!isFull()) {
			super.push(item);
			return item;
		}

		if (shiftable) {
			remove(0);
			push(item);
		}
		
		return item;
	}

	public boolean isFull() {
		return size() == maxSize;
	}

	public static void main(String[] args) {
		FixedSizeStack<String> stack = new FixedSizeStack<String>(5, true);
		stack.push("un");
		stack.push("deux");
		stack.push("trois");
		stack.push("quatre");
		stack.push("cinq");
		System.out.println(stack);
		System.out.println("push(6)");
		stack.push("six");
		System.out.println(stack);
		System.out.println("pop()");
		stack.pop();
		System.out.println("push(7)");
		stack.push("sept");
		System.out.println(stack);
	}
}
