package fr.iri.thd.sonyengine.core;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;


public class DataAccessor {

	public PrimaryIndex<String, MovieFragment> movieFragmentById;
	
	public PrimaryIndex<String, Tag> tagById;
	public SecondaryIndex<String, String, Tag> tagByName;
	public SecondaryIndex<String, String, Tag> tagBySegment;
	
	public DataAccessor(EntityStore store) throws DatabaseException {
		
		movieFragmentById = store.getPrimaryIndex(String.class, MovieFragment.class);
		
		tagById = store.getPrimaryIndex(String.class, Tag.class);
		tagByName = store.getSecondaryIndex(tagById, String.class, "name");
		tagBySegment = store.getSecondaryIndex(tagById, String.class, "segment");	
		
	}
	
}
