/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatchedLockManager
extends LockManager {
    public LatchedLockManager(EnvironmentImpl envImpl) {
        super(envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Lock lookupLock(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Lock lock = this.lookupLockInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
            latch.release();
            return lock;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LockAttemptResult attemptLock(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            LockAttemptResult lockAttemptResult = this.attemptLockInternal(nodeId, locker, type, nonBlockingRequest, lockTableIndex);
            Object var9_8 = null;
            latch.release();
            return lockAttemptResult;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LockConflictException makeTimeoutMsg(boolean isLockNotTxnTimeout, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            LockConflictException lockConflictException = this.makeTimeoutMsgInternal(isLockNotTxnTimeout, locker, nodeId, type, grantType, useLock, timeout, start, now, database);
            Object var19_14 = null;
            latch.release();
            return lockConflictException;
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<Locker> releaseAndFindNotifyTargets(long nodeId, Locker locker) throws DatabaseException {
        long nid = nodeId;
        int lockTableIndex = this.getLockTableIndex(nid);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Set<Locker> set = this.releaseAndFindNotifyTargetsInternal(nodeId, locker, lockTableIndex);
            Object var10_7 = null;
            latch.release();
            return set;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void transfer(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferInternal(nodeId, owningLocker, destLocker, demoteToRead, lockTableIndex);
            Object var9_7 = null;
            latch.release();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void transferMultiple(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferMultipleInternal(nodeId, owningLocker, destLockers, lockTableIndex);
            Object var8_6 = null;
            latch.release();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void demote(long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.demoteInternal(nodeId, locker, lockTableIndex);
            Object var7_5 = null;
            latch.release();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isLocked(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isLockedInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
            latch.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isOwner(Long nodeId, Locker locker, LockType type) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isOwnerInternal(nodeId, locker, type, lockTableIndex);
            Object var8_7 = null;
            latch.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isWaiter(Long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isWaiterInternal(nodeId, locker, lockTableIndex);
            Object var7_6 = null;
            latch.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int nWaiters(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            int n = this.nWaitersInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
            latch.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int nOwners(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            int n = this.nOwnersInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
            latch.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Locker getWriteOwnerLocker(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Locker locker = this.getWriteOwnerLockerInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
            latch.release();
            return locker;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean validateOwnership(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.validateOwnershipInternal(nodeId, locker, type, flushFromWaiters, mb, lockTableIndex);
            Object var10_9 = null;
            latch.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LockAttemptResult stealLock(Long nodeId, Locker locker, LockType lockType, MemoryBudget mb) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            LockAttemptResult lockAttemptResult = this.stealLockInternal(nodeId, locker, lockType, mb, lockTableIndex);
            Object var9_8 = null;
            latch.release();
            return lockAttemptResult;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            latch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dumpLockTable(StatGroup stats, boolean clear) throws DatabaseException {
        for (int i = 0; i < this.nLockTables; ++i) {
            Object var5_4;
            this.lockTableLatches[i].acquire();
            try {
                this.dumpLockTableInternal(stats, i, clear);
                var5_4 = null;
                this.lockTableLatches[i].release();
                continue;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.lockTableLatches[i].release();
                throw throwable;
            }
        }
    }
}

