/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.incomp.INCompStatDefinition;
import com.sleepycat.je.latch.LatchStatDefinition;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.recovery.CheckpointStatDefinition;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentStats
implements Serializable {
    private static final long serialVersionUID = 1734048134L;
    private StatGroup incompStats;
    private StatGroup cacheStats;
    private StatGroup ckptStats;
    private StatGroup cleanerStats;
    private StatGroup logStats;
    private StatGroup lockStats;
    private StatGroup envImplStats;
    private final Map<String, String> tipsMap = new HashMap<String, String>();

    public EnvironmentStats() {
        this.incompStats = new StatGroup("Node Compression", "Removal and compression of internal btree nodes.");
        this.cacheStats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.ckptStats = new StatGroup("Checkpoints", "Frequency and extent of checkpointing activity.");
        this.cleanerStats = new StatGroup("Cleaning", "Frequency and extent of log file cleaning activity.");
        this.logStats = new StatGroup("I/O", "Log file opens, fsyncs, reads, writes, cache misses.");
        this.lockStats = new StatGroup("Locks", "Locks held by data operations, latching contention on lock table.");
        this.envImplStats = new StatGroup("Environment", "General environment wide statistics.");
    }

    public static String[] getStatGroupTitles() {
        return new String[]{"I/O", "Cache", "Cleaning", "Node Compression", "Checkpoints", "Environment", "Locks"};
    }

    public void setINCompStats(StatGroup stats) {
        this.incompStats = stats;
    }

    public void setCkptStats(StatGroup stats) {
        this.ckptStats = stats;
    }

    public void setCleanerStats(StatGroup stats) {
        this.cleanerStats = stats;
    }

    public void setLogStats(StatGroup stats) {
        this.logStats = stats;
    }

    public void setMBAndEvictorStats(StatGroup mbStats, StatGroup evictorStats) {
        this.cacheStats = evictorStats.cloneGroup(false);
        this.cacheStats.addAll(mbStats);
    }

    public void setLockStats(StatGroup stats) {
        this.lockStats = stats;
    }

    public void setEnvImplStats(StatGroup stats) {
        this.envImplStats = stats;
    }

    public long getCursorsBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_CURSORS_BINS);
    }

    public long getDbClosedBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_DBCLOSED_BINS);
    }

    public long getInCompQueueSize() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_QUEUE_SIZE);
    }

    public long getNonEmptyBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_NON_EMPTY_BINS);
    }

    public long getProcessedBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_PROCESSED_BINS);
    }

    public long getSplitBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_SPLIT_BINS);
    }

    public long getLastCheckpointId() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPTID);
    }

    public long getNCheckpoints() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_CHECKPOINTS);
    }

    public long getNFullINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_FULL_IN_FLUSH);
    }

    public long getNFullBINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH);
    }

    public long getNDeltaINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH);
    }

    public long getLastCheckpointStart() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_START);
    }

    public long getLastCheckpointEnd() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_END);
    }

    public int getCleanerBacklog() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_BACKLOG);
    }

    public int getFileDeletionBacklog() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG);
    }

    public long getNCleanerRuns() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_RUNS);
    }

    public long getNCleanerDeletions() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_DELETIONS);
    }

    public long getNCleanerEntriesRead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_ENTRIES_READ);
    }

    public long getNINsObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_OBSOLETE);
    }

    public long getNINsCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_CLEANED);
    }

    public long getNINsDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_DEAD);
    }

    public long getNINsMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_MIGRATED);
    }

    public long getNLNsObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
    }

    public long getNLNsCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_CLEANED);
    }

    public long getNLNsDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_DEAD);
    }

    public long getNLNsLocked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_LOCKED);
    }

    public long getNLNsMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_MIGRATED);
    }

    public long getNLNsMarked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_MARKED);
    }

    public long getNLNQueueHits() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
    }

    public long getNPendingLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
    }

    public long getNMarkedLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED);
    }

    public long getNToBeCleanedLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED);
    }

    public long getNClusterLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED);
    }

    public long getNPendingLNsLocked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
    }

    public long getNRepeatIteratorReads() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS);
    }

    public long getTotalLogSize() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE);
    }

    public long getNCacheMiss() {
        return this.logStats.getLong(LogStatDefinition.LBFP_MISS);
    }

    public long getEndOfLog() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_END_OF_LOG);
    }

    public long getNFSyncs() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNCS);
    }

    public long getNFSyncRequests() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS);
    }

    public long getNFSyncTimeouts() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNC_TIMEOUTS);
    }

    public int getNLogBuffers() {
        return this.logStats.getInt(LogStatDefinition.LBFP_LOG_BUFFERS);
    }

    public long getNRandomReads() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_READS);
    }

    public long getNRandomReadBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_READ_BYTES);
    }

    public long getNRandomWrites() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_WRITES);
    }

    public long getNRandomWriteBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES);
    }

    public long getNSequentialReads() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_READS);
    }

    public long getNSequentialReadBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES);
    }

    public long getNSequentialWrites() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES);
    }

    public long getNSequentialWriteBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES);
    }

    public long getNBytesReadFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE);
    }

    public long getNBytesWrittenFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE);
    }

    public long getNReadsFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE);
    }

    public long getNWritesFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE);
    }

    public long getNWriteQueueOverflow() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW);
    }

    public long getNWriteQueueOverflowFailures() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES);
    }

    public long getBufferBytes() {
        return this.logStats.getLong(LogStatDefinition.LBFP_BUFFER_BYTES);
    }

    public long getNNotResident() {
        return this.logStats.getLong(LogStatDefinition.LBFP_NOT_RESIDENT);
    }

    public long getNRepeatFaultReads() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_REPEAT_FAULT_READS);
    }

    public long getNTempBufferWrites() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES);
    }

    public int getNFileOpens() {
        return this.logStats.getInt(LogStatDefinition.FILEMGR_FILE_OPENS);
    }

    public int getNOpenFiles() {
        return this.logStats.getInt(LogStatDefinition.FILEMGR_OPEN_FILES);
    }

    public long getNEvictPasses() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_EVICT_PASSES);
    }

    public long getNNodesExplicitlyEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_EVICTED);
    }

    public long getNRootNodesEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
    }

    public long getNBINsStripped() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_BINS_STRIPPED);
    }

    public long getRequiredEvictBytes() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES);
    }

    public long getNNodesScanned() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_SCANNED);
    }

    public long getNNodesSelected() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_SELECTED);
    }

    public int getNSharedCacheEnvironments() {
        return this.cacheStats.getInt(EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);
    }

    public long getSharedCacheTotalBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES);
    }

    public long getCacheTotalBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_TOTAL_BYTES);
    }

    public long getDataBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_DATA_BYTES);
    }

    public long getAdminBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_ADMIN_BYTES);
    }

    public long getLockBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_LOCK_BYTES);
    }

    public long getCacheDataBytes() {
        return this.getCacheTotalBytes() - this.getBufferBytes();
    }

    public long getRelatchesRequired() {
        return this.envImplStats.getLong(DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED);
    }

    public int getNOwners() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_OWNERS);
    }

    public int getNReadLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_READ_LOCKS);
    }

    public int getNTotalLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_TOTAL);
    }

    public int getNWaiters() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_WAITERS);
    }

    public int getNWriteLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_WRITE_LOCKS);
    }

    public long getNRequests() {
        return this.lockStats.getLong(LockStatDefinition.LOCK_REQUESTS);
    }

    public long getNWaits() {
        return this.lockStats.getLong(LockStatDefinition.LOCK_WAITS);
    }

    public int getNAcquiresNoWaiters() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NO_WAITERS);
    }

    public int getNAcquiresSelfOwned() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_SELF_OWNED);
    }

    public int getNAcquiresWithContention() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_CONTENTION);
    }

    public int getNAcquiresNoWaitSuccessful() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NOWAIT_SUCCESS);
    }

    public int getNAcquiresNoWaitUnSuccessful() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS);
    }

    public int getNReleases() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_RELEASES);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.logStats.toString());
        sb.append(this.cacheStats.toString());
        sb.append(this.cleanerStats.toString());
        sb.append(this.incompStats.toString());
        sb.append(this.ckptStats.toString());
        sb.append(this.envImplStats.toString());
        sb.append(this.lockStats.toString());
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.logStats.toStringVerbose());
        sb.append(this.cacheStats.toStringVerbose());
        sb.append(this.cleanerStats.toStringVerbose());
        sb.append(this.incompStats.toStringVerbose());
        sb.append(this.ckptStats.toStringVerbose());
        sb.append(this.envImplStats.toStringVerbose());
        sb.append(this.lockStats.toStringVerbose());
        return sb.toString();
    }

    public Map<String, String> getTips() {
        this.tipsMap.put(this.cleanerStats.getName(), this.cleanerStats.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_BACKLOG.getName(), CleanerStatDefinition.CLEANER_BACKLOG.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED.getName(), CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_DELETIONS.getName(), CleanerStatDefinition.CLEANER_DELETIONS.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_ENTRIES_READ.getName(), CleanerStatDefinition.CLEANER_ENTRIES_READ.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG.getName(), CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_INS_CLEANED.getName(), CleanerStatDefinition.CLEANER_INS_CLEANED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_INS_DEAD.getName(), CleanerStatDefinition.CLEANER_INS_DEAD.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_INS_MIGRATED.getName(), CleanerStatDefinition.CLEANER_INS_MIGRATED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_INS_OBSOLETE.getName(), CleanerStatDefinition.CLEANER_INS_OBSOLETE.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNQUEUE_HITS.getName(), CleanerStatDefinition.CLEANER_LNQUEUE_HITS.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNS_CLEANED.getName(), CleanerStatDefinition.CLEANER_LNS_CLEANED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNS_DEAD.getName(), CleanerStatDefinition.CLEANER_LNS_DEAD.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNS_LOCKED.getName(), CleanerStatDefinition.CLEANER_LNS_LOCKED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNS_MARKED.getName(), CleanerStatDefinition.CLEANER_LNS_MARKED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNS_MIGRATED.getName(), CleanerStatDefinition.CLEANER_LNS_MIGRATED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_LNS_OBSOLETE.getName(), CleanerStatDefinition.CLEANER_LNS_OBSOLETE.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED.getName(), CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED.getName(), CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED.getName(), CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS.getName(), CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_RUNS.getName(), CleanerStatDefinition.CLEANER_RUNS.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE.getName(), CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE.getDescription());
        this.tipsMap.put(CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED.getName(), CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED.getDescription());
        this.tipsMap.put(this.envImplStats.getName(), this.envImplStats.getDescription());
        this.tipsMap.put(DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED.getName(), DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED.getDescription());
        this.tipsMap.put(this.cacheStats.getName(), this.cacheStats.getDescription());
        this.tipsMap.put(DbiStatDefinition.MB_ADMIN_BYTES.getName(), DbiStatDefinition.MB_ADMIN_BYTES.getDescription());
        this.tipsMap.put(DbiStatDefinition.MB_DATA_BYTES.getName(), DbiStatDefinition.MB_DATA_BYTES.getDescription());
        this.tipsMap.put(DbiStatDefinition.MB_LOCK_BYTES.getName(), DbiStatDefinition.MB_LOCK_BYTES.getDescription());
        this.tipsMap.put(DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES.getName(), DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES.getDescription());
        this.tipsMap.put(DbiStatDefinition.MB_TOTAL_BYTES.getName(), DbiStatDefinition.MB_TOTAL_BYTES.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_BINS_STRIPPED.getName(), EvictorStatDefinition.EVICTOR_BINS_STRIPPED.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_EVICT_PASSES.getName(), EvictorStatDefinition.EVICTOR_EVICT_PASSES.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_NODES_EVICTED.getName(), EvictorStatDefinition.EVICTOR_NODES_EVICTED.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_NODES_SCANNED.getName(), EvictorStatDefinition.EVICTOR_NODES_SCANNED.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_NODES_SELECTED.getName(), EvictorStatDefinition.EVICTOR_NODES_SELECTED.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES.getName(), EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED.getName(), EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED.getDescription());
        this.tipsMap.put(EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS.getName(), EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS.getDescription());
        this.tipsMap.put(this.incompStats.getName(), this.incompStats.getDescription());
        this.tipsMap.put(INCompStatDefinition.INCOMP_CURSORS_BINS.getName(), INCompStatDefinition.INCOMP_CURSORS_BINS.getDescription());
        this.tipsMap.put(INCompStatDefinition.INCOMP_DBCLOSED_BINS.getName(), INCompStatDefinition.INCOMP_DBCLOSED_BINS.getDescription());
        this.tipsMap.put(INCompStatDefinition.INCOMP_NON_EMPTY_BINS.getName(), INCompStatDefinition.INCOMP_NON_EMPTY_BINS.getDescription());
        this.tipsMap.put(INCompStatDefinition.INCOMP_PROCESSED_BINS.getName(), INCompStatDefinition.INCOMP_PROCESSED_BINS.getDescription());
        this.tipsMap.put(INCompStatDefinition.INCOMP_QUEUE_SIZE.getName(), INCompStatDefinition.INCOMP_QUEUE_SIZE.getDescription());
        this.tipsMap.put(INCompStatDefinition.INCOMP_SPLIT_BINS.getName(), INCompStatDefinition.INCOMP_SPLIT_BINS.getDescription());
        this.tipsMap.put(this.lockStats.getName(), this.lockStats.getDescription());
        this.tipsMap.put(LatchStatDefinition.LATCH_CONTENTION.getName(), LatchStatDefinition.LATCH_CONTENTION.getDescription());
        this.tipsMap.put(LatchStatDefinition.LATCH_NOWAIT_SUCCESS.getName(), LatchStatDefinition.LATCH_NOWAIT_SUCCESS.getDescription());
        this.tipsMap.put(LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS.getName(), LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS.getDescription());
        this.tipsMap.put(LatchStatDefinition.LATCH_NO_WAITERS.getName(), LatchStatDefinition.LATCH_NO_WAITERS.getDescription());
        this.tipsMap.put(LatchStatDefinition.LATCH_RELEASES.getName(), LatchStatDefinition.LATCH_RELEASES.getDescription());
        this.tipsMap.put(LatchStatDefinition.LATCH_SELF_OWNED.getName(), LatchStatDefinition.LATCH_SELF_OWNED.getDescription());
        this.tipsMap.put(this.logStats.getName(), this.logStats.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE.getName(), LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE.getName(), LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_FILE_OPENS.getName(), LogStatDefinition.FILEMGR_FILE_OPENS.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_OPEN_FILES.getName(), LogStatDefinition.FILEMGR_OPEN_FILES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_RANDOM_READS.getName(), LogStatDefinition.FILEMGR_RANDOM_READS.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_RANDOM_READ_BYTES.getName(), LogStatDefinition.FILEMGR_RANDOM_READ_BYTES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_RANDOM_WRITES.getName(), LogStatDefinition.FILEMGR_RANDOM_WRITES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES.getName(), LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE.getName(), LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_SEQUENTIAL_READS.getName(), LogStatDefinition.FILEMGR_SEQUENTIAL_READS.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES.getName(), LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES.getName(), LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES.getName(), LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW.getName(), LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES.getName(), LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES.getDescription());
        this.tipsMap.put(LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE.getName(), LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE.getDescription());
        this.tipsMap.put(LogStatDefinition.FSYNCMGR_FSYNCS.getName(), LogStatDefinition.FSYNCMGR_FSYNCS.getDescription());
        this.tipsMap.put(LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS.getName(), LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS.getDescription());
        this.tipsMap.put(LogStatDefinition.FSYNCMGR_FSYNC_TIMEOUTS.getName(), LogStatDefinition.FSYNCMGR_FSYNC_TIMEOUTS.getDescription());
        this.tipsMap.put(LogStatDefinition.LBFP_BUFFER_BYTES.getName(), LogStatDefinition.LBFP_BUFFER_BYTES.getDescription());
        this.tipsMap.put(LogStatDefinition.LBFP_LOG_BUFFERS.getName(), LogStatDefinition.LBFP_LOG_BUFFERS.getDescription());
        this.tipsMap.put(LogStatDefinition.LBFP_MISS.getName(), LogStatDefinition.LBFP_MISS.getDescription());
        this.tipsMap.put(LogStatDefinition.LBFP_NOT_RESIDENT.getName(), LogStatDefinition.LBFP_NOT_RESIDENT.getDescription());
        this.tipsMap.put(LogStatDefinition.LOGMGR_END_OF_LOG.getName(), LogStatDefinition.LOGMGR_END_OF_LOG.getDescription());
        this.tipsMap.put(LogStatDefinition.LOGMGR_REPEAT_FAULT_READS.getName(), LogStatDefinition.LOGMGR_REPEAT_FAULT_READS.getDescription());
        this.tipsMap.put(LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES.getName(), LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES.getDescription());
        this.tipsMap.put(this.ckptStats.getName(), this.ckptStats.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_CHECKPOINTS.getName(), CheckpointStatDefinition.CKPT_CHECKPOINTS.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH.getName(), CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH.getName(), CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_FULL_IN_FLUSH.getName(), CheckpointStatDefinition.CKPT_FULL_IN_FLUSH.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_LAST_CKPTID.getName(), CheckpointStatDefinition.CKPT_LAST_CKPTID.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_LAST_CKPT_END.getName(), CheckpointStatDefinition.CKPT_LAST_CKPT_END.getDescription());
        this.tipsMap.put(CheckpointStatDefinition.CKPT_LAST_CKPT_START.getName(), CheckpointStatDefinition.CKPT_LAST_CKPT_START.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_OWNERS.getName(), LockStatDefinition.LOCK_OWNERS.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_READ_LOCKS.getName(), LockStatDefinition.LOCK_READ_LOCKS.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_REQUESTS.getName(), LockStatDefinition.LOCK_REQUESTS.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_TOTAL.getName(), LockStatDefinition.LOCK_TOTAL.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_WAITERS.getName(), LockStatDefinition.LOCK_WAITERS.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_WAITS.getName(), LockStatDefinition.LOCK_WAITS.getDescription());
        this.tipsMap.put(LockStatDefinition.LOCK_WRITE_LOCKS.getName(), LockStatDefinition.LOCK_WRITE_LOCKS.getDescription());
        return this.tipsMap;
    }
}

