/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.method.dispatch;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.model.method.dispatch.FormDispatchProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.sun.jersey.spi.inject.Injectable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartFormDispatchProvider
extends FormDispatchProvider {
    private static MediaType MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
    @Context
    private MessageBodyWorkers mbws;

    @Override
    protected void processForm(HttpContext context) {
        MediaType m = context.getRequest().getMediaType();
        if (MediaTypes.typeEquals(MULTIPART_FORM_DATA, m)) {
            MimeMultipart form = context.getRequest().getEntity(MimeMultipart.class);
            try {
                Map<String, FormDataBodyPart> formMap = MultipartFormDispatchProvider.getFormData(form);
                context.getProperties().put("com.sun.jersey.api.representation.form", formMap);
                context.getProperties().put("com.sun.jersey.api.representation.form.multipart", form);
            }
            catch (Exception e) {
                throw new ContainerException(e);
            }
        } else {
            super.processForm(context);
        }
    }

    @Override
    public RequestDispatcher create(AbstractResourceMethod method) {
        MediaType m;
        boolean found = false;
        Iterator<MediaType> i$ = method.getSupportedInputTypes().iterator();
        while (i$.hasNext() && !(found = !(m = i$.next()).isWildcardSubtype() && m.isCompatible(MULTIPART_FORM_DATA))) {
        }
        if (!found) {
            return null;
        }
        return super.create(method);
    }

    @Override
    protected List<Injectable> getInjectables(AbstractResourceMethod method) {
        ArrayList<Injectable> is = new ArrayList<Injectable>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter p = method.getParameters().get(i);
            if (Parameter.Source.ENTITY == p.getSource()) {
                if (MimeMultipart.class.isAssignableFrom(p.getParameterClass()) || MultivaluedMap.class.isAssignableFrom(p.getParameterClass())) {
                    is.add(new MultipartFormInjectable(p.getParameterClass(), p.getParameterType(), p.getAnnotations()));
                    continue;
                }
                is.add(null);
                continue;
            }
            if (p.getAnnotation().annotationType() == FormParam.class) {
                if (FormDataContentDisposition.class == p.getParameterClass()) {
                    is.add(new DispositionParamInjectable(p));
                    continue;
                }
                is.add(new MultipartFormParamInjectable(this.mbws, this.getMultivaluedParameterExtractorProvider(), p));
                continue;
            }
            Injectable injectable = this.getInjectableProviderContext().getInjectable(p, ComponentScope.PerRequest);
            is.add(injectable);
        }
        return is;
    }

    private static Map<String, FormDataBodyPart> getFormData(MimeMultipart mm) throws Exception {
        HashMap<String, FormDataBodyPart> m = new HashMap<String, FormDataBodyPart>();
        for (int i = 0; i < mm.getCount(); ++i) {
            FormDataContentDisposition fdcd;
            BodyPart b = mm.getBodyPart(i);
            if (b.getDisposition() == null || !b.getDisposition().equalsIgnoreCase("form-data") || (fdcd = new FormDataContentDisposition(b.getHeader("content-disposition")[0])).getName() == null) continue;
            m.put(fdcd.getName(), new FormDataBodyPart(b, fdcd));
        }
        return m;
    }

    private static class FormDataBodyPart {
        final BodyPart bp;
        final FormDataContentDisposition fdcd;

        FormDataBodyPart(BodyPart bp, FormDataContentDisposition fdcd) {
            this.bp = bp;
            this.fdcd = fdcd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MultipartFormParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final MessageBodyWorkers mbws;
        private final Parameter p;
        private final MultivaluedParameterExtractor extractor;

        MultipartFormParamInjectable(MessageBodyWorkers mbws, MultivaluedParameterExtractorProvider mpep, Parameter p) {
            this.mbws = mbws;
            this.p = p;
            this.extractor = mpep.get(p);
        }

        @Override
        public Object getValue(HttpContext context) {
            try {
                Object o = context.getProperties().get("com.sun.jersey.api.representation.form");
                if (o instanceof Form) {
                    return this.getAsForm((Form)o, context);
                }
                return this.getAsMultipartFormData((Map)o, context);
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
        }

        private Object getAsForm(Form form, HttpContext context) throws Exception {
            MessageBodyReader<?> r = this.mbws.getMessageBodyReader(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), MediaType.TEXT_PLAIN_TYPE);
            if (r != null) {
                String c = form.getFirst(this.p.getSourceName());
                if (c == null) {
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(c.getBytes("UTF-8"));
                return r.readFrom(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), MediaType.TEXT_PLAIN_TYPE, context.getRequest().getRequestHeaders(), (InputStream)is);
            }
            if (this.extractor != null) {
                return this.extractor.extract(form);
            }
            return null;
        }

        private Object getAsMultipartFormData(Map<String, FormDataBodyPart> formMap, HttpContext context) throws Exception {
            FormDataBodyPart fdbp = formMap.get(this.p.getSourceName());
            if (fdbp == null) {
                return null;
            }
            MediaType m = fdbp.bp.getContentType() == null ? MediaType.TEXT_PLAIN_TYPE : MediaType.valueOf((String)fdbp.bp.getContentType());
            Object r = this.mbws.getMessageBodyReader(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), m);
            if (r != null) {
                return r.readFrom(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), m, context.getRequest().getRequestHeaders(), fdbp.bp.getInputStream());
            }
            if (this.extractor != null) {
                r = this.mbws.getMessageBodyReader(String.class, (Type)((Object)String.class), this.p.getAnnotations(), m);
                String v = (String)r.readFrom(String.class, String.class, this.p.getAnnotations(), m, context.getRequest().getRequestHeaders(), fdbp.bp.getInputStream());
                MultivaluedMapImpl mvm = new MultivaluedMapImpl();
                mvm.putSingle(this.p.getSourceName(), v);
                return this.extractor.extract(mvm);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DispositionParamInjectable
    extends AbstractHttpContextInjectable<FormDataContentDisposition> {
        private final String name;

        DispositionParamInjectable(Parameter p) {
            this.name = p.getSourceName();
        }

        @Override
        public FormDataContentDisposition getValue(HttpContext context) {
            try {
                Object o = context.getProperties().get("com.sun.jersey.api.representation.form");
                if (o instanceof Form) {
                    return null;
                }
                Map formMap = (Map)o;
                FormDataBodyPart fdbp = (FormDataBodyPart)formMap.get(this.name);
                if (fdbp == null) {
                    return null;
                }
                return fdbp.fdcd;
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MultipartFormInjectable
    extends AbstractHttpContextInjectable<Object> {
        final Class<?> c;
        final Type t;
        final Annotation[] as;

        MultipartFormInjectable(Class c, Type t, Annotation[] as) {
            this.c = c;
            this.t = t;
            this.as = as;
        }

        @Override
        public Object getValue(HttpContext context) {
            Object o = context.getProperties().get("com.sun.jersey.api.representation.form.multipart");
            if (o != null) {
                return o;
            }
            return context.getProperties().get("com.sun.jersey.api.representation.form");
        }
    }
}

