/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class Resample
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 7079064953548300681L;
    protected double m_SampleSizePercent = 100.0;
    protected int m_RandomSeed = 1;
    protected double m_BiasToUniformClass = 0.0;
    protected boolean m_NoReplacement = false;
    protected boolean m_InvertSelection = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using either sampling with replacement or without replacement.\nThe original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified. The dataset must have a nominal class attribute. If not, use the unsupervised version. The filter can be made to maintain the class distribution in the subsample, or to bias the class distribution toward a uniform distribution. When used in batch mode (i.e. in the FilteredClassifier), subsequent batches are NOT resampled.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        vector.addElement(new Option("\tBias factor towards uniform class distribution.\n\t0 = distribution in input data -- 1 = uniform distribution.\n\t(default 0)", "B", 1, "-B <num>"));
        vector.addElement(new Option("\tDisables replacement of instances\n\t(default: with replacement)", "no-replacement", 0, "-no-replacement"));
        vector.addElement(new Option("\tInverts the selection - only available with '-no-replacement'.", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setBiasToUniformClass(Double.parseDouble(string));
        } else {
            this.setBiasToUniformClass(0.0);
        }
        string = Utils.getOption('Z', stringArray);
        if (string.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(string));
        } else {
            this.setSampleSizePercent(100.0);
        }
        this.setNoReplacement(Utils.getFlag("no-replacement", stringArray));
        if (this.getNoReplacement()) {
            this.setInvertSelection(Utils.getFlag('V', stringArray));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-B");
        vector.add("" + this.getBiasToUniformClass());
        vector.add("-S");
        vector.add("" + this.getRandomSeed());
        vector.add("-Z");
        vector.add("" + this.getSampleSizePercent());
        if (this.getNoReplacement()) {
            vector.add("-no-replacement");
            if (this.getInvertSelection()) {
                vector.add("-V");
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String biasToUniformClassTipText() {
        return "Whether to use bias towards a uniform class. A value of 0 leaves the class distribution as-is, a value of 1 ensures the class distribution is uniform in the output data.";
    }

    public double getBiasToUniformClass() {
        return this.m_BiasToUniformClass;
    }

    public void setBiasToUniformClass(double d) {
        this.m_BiasToUniformClass = d;
    }

    public String randomSeedTipText() {
        return "Sets the random number seed for subsampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public String sampleSizePercentTipText() {
        return "The subsample size as a percentage of the original set.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double d) {
        this.m_SampleSizePercent = d;
    }

    public String noReplacementTipText() {
        return "Disables the replacement of instances.";
    }

    public boolean getNoReplacement() {
        return this.m_NoReplacement;
    }

    public void setNoReplacement(boolean bl) {
        this.m_NoReplacement = bl;
    }

    public String invertSelectionTipText() {
        return "Inverts the selection (only if instances are drawn WITHOUT replacement).";
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public void setInvertSelection(boolean bl) {
        this.m_InvertSelection = bl;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public void createSubsampleWithReplacement(Random random, int n, int n2, int n3, int[] nArray) {
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            if (random.nextDouble() < this.m_BiasToUniformClass) {
                int n5 = random.nextInt(n3);
                int n6 = 0;
                for (int j = 0; j < nArray.length - 1; ++j) {
                    if (nArray[j] == nArray[j + 1] || n6++ < n5) continue;
                    n4 = nArray[j] + random.nextInt(nArray[j + 1] - nArray[j]);
                    break;
                }
            } else {
                n4 = random.nextInt(n);
            }
            this.push((Instance)this.getInputFormat().instance(n4).copy());
        }
    }

    public void createSubsampleWithoutReplacement(Random random, int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5;
        int n6;
        if (n2 > n) {
            n2 = n;
            System.err.println("Resampling with replacement can only use percentage <=100% - Using full dataset!");
        }
        Vector[] vectorArray = new Vector[n3];
        Vector[] vectorArray2 = new Vector[n3];
        for (n6 = 0; n6 < n3; ++n6) {
            vectorArray[n6] = new Vector(nArray[n6 + 1] - nArray[n6]);
            vectorArray2[n6] = new Vector(vectorArray[n6].capacity());
            for (n5 = nArray[n6]; n5 < nArray[n6 + 1]; ++n5) {
                vectorArray[n6].add(n5);
            }
        }
        n6 = n;
        block2: for (n5 = 0; n5 < n2; ++n5) {
            int n7;
            n4 = 0;
            if (random.nextDouble() < this.m_BiasToUniformClass) {
                n7 = random.nextInt(n3);
                int n8 = 0;
                for (int i = 0; i < nArray.length - 1; ++i) {
                    if (nArray[i] == nArray[i + 1] || n8++ < n7) continue;
                    n4 = random.nextInt(vectorArray[i].size());
                    vectorArray2[i].add(vectorArray[i].get(n4));
                    vectorArray[i].remove(n4);
                    continue block2;
                }
                continue;
            }
            n4 = random.nextInt(n6);
            for (n7 = 0; n7 < n3; ++n7) {
                if (n4 < vectorArray[n7].size()) {
                    vectorArray2[n7].add(vectorArray[n7].get(n4));
                    vectorArray[n7].remove(n4);
                    break;
                }
                n4 -= vectorArray[n7].size();
            }
            --n6;
        }
        if (this.getInvertSelection()) {
            vectorArray2 = vectorArray;
        } else {
            for (n5 = 0; n5 < vectorArray2.length; ++n5) {
                Collections.sort(vectorArray2[n5]);
            }
        }
        for (n5 = 0; n5 < vectorArray2.length; ++n5) {
            for (n4 = 0; n4 < vectorArray2[n5].size(); ++n4) {
                this.push((Instance)this.getInputFormat().instance((Integer)vectorArray2[n5].get(n4)).copy());
            }
        }
        for (n5 = 0; n5 < vectorArray.length; ++n5) {
            vectorArray[n5].clear();
            vectorArray2[n5].clear();
        }
        vectorArray = null;
        vectorArray2 = null;
    }

    protected void createSubsample() {
        int n;
        int n2 = this.getInputFormat().numInstances();
        int n3 = (int)((double)n2 * this.m_SampleSizePercent / 100.0);
        this.getInputFormat().sort(this.getInputFormat().classIndex());
        int[] nArray = new int[this.getInputFormat().numClasses() + 1];
        int n4 = 0;
        nArray[n4] = 0;
        for (n = 0; n < this.getInputFormat().numInstances(); ++n) {
            int n5;
            Instance instance = this.getInputFormat().instance(n);
            if (instance.classIsMissing()) {
                for (n5 = n4 + 1; n5 < nArray.length; ++n5) {
                    nArray[n5] = n;
                }
                break;
            }
            if (instance.classValue() == (double)n4) continue;
            n5 = n4 + 1;
            while ((double)n5 <= instance.classValue()) {
                nArray[n5] = n;
                ++n5;
            }
            n4 = (int)instance.classValue();
        }
        if (n4 <= this.getInputFormat().numClasses()) {
            for (n = n4 + 1; n < nArray.length; ++n) {
                nArray[n] = this.getInputFormat().numInstances();
            }
        }
        n = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (nArray[i] == nArray[i + 1]) continue;
            ++n;
        }
        Random random = new Random(this.m_RandomSeed);
        if (this.getNoReplacement()) {
            this.createSubsampleWithoutReplacement(random, n2, n3, n, nArray);
        } else {
            this.createSubsampleWithReplacement(random, n2, n3, n, nArray);
        }
    }

    public static void main(String[] stringArray) {
        Resample.runFilter(new Resample(), stringArray);
    }
}

