/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Option;
import weka.core.Range;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.datagenerators.ClusterDefinition;
import weka.datagenerators.ClusterGenerator;
import weka.datagenerators.clusterers.SubspaceCluster;

public class SubspaceClusterDefinition
extends ClusterDefinition {
    static final long serialVersionUID = 3135678125044007231L;
    protected int m_clustertype;
    protected int m_clustersubtype;
    protected int m_numClusterAttributes;
    protected int m_numInstances;
    protected int m_MinInstNum;
    protected int m_MaxInstNum;
    protected Range m_AttrIndexRange;
    protected boolean[] m_attributes;
    protected int[] m_attrIndices;
    protected double[] m_minValue;
    protected double[] m_maxValue;
    protected double[] m_meanValue;
    protected double[] m_stddevValue;

    public SubspaceClusterDefinition() {
    }

    public SubspaceClusterDefinition(ClusterGenerator clusterGenerator) {
        super(clusterGenerator);
    }

    protected void setDefaults() throws Exception {
        this.setClusterType(this.defaultClusterType());
        this.setClusterSubType(this.defaultClusterSubType());
        this.setMinInstNum(this.defaultMinInstNum());
        this.setMaxInstNum(this.defaultMaxInstNum());
        this.setAttrIndexRange(this.defaultAttrIndexRange());
        this.m_numClusterAttributes = 1;
        this.setValuesList(this.defaultValuesList());
    }

    public String globalInfo() {
        return "A single cluster for the SubspaceCluster datagenerator";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tGenerates randomly distributed instances in the cluster.", "A", 1, "-A <range>"));
        vector.addElement(new Option("\tGenerates uniformly distributed instances in the cluster.", "U", 1, "-U <range>"));
        vector.addElement(new Option("\tGenerates gaussian distributed instances in the cluster.", "G", 1, "-G <range>"));
        vector.addElement(new Option("\tThe attribute min/max (-A and -U) or mean/stddev (-G) for\n\tthe cluster.", "D", 1, "-D <num>,<num>"));
        vector.addElement(new Option("\tThe range of number of instances per cluster (default " + this.defaultMinInstNum() + ".." + this.defaultMaxInstNum() + ").", "N", 1, "-N <num>..<num>"));
        vector.addElement(new Option("\tUses integer instead of continuous values (default continuous).", "I", 0, "-I"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        int n = 0;
        String string = "";
        String string2 = Utils.getOption('A', stringArray);
        if (string2.length() != 0) {
            string = string2;
            this.setClusterType(new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERTYPE));
            ++n;
        }
        if ((string2 = Utils.getOption('U', stringArray)).length() != 0) {
            string = string2;
            this.setClusterType(new SelectedTag(1, SubspaceCluster.TAGS_CLUSTERTYPE));
            ++n;
        }
        if ((string2 = Utils.getOption('G', stringArray)).length() != 0) {
            string = string2;
            this.setClusterType(new SelectedTag(2, SubspaceCluster.TAGS_CLUSTERTYPE));
            ++n;
        }
        if (n == 0) {
            this.setClusterType(new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERTYPE));
        } else if (n > 1) {
            throw new Exception("Only one cluster type can be specified!");
        }
        this.setAttrIndexRange(string);
        string2 = Utils.getOption('D', stringArray);
        if (this.isGaussian()) {
            if (string2.length() != 0) {
                this.setMeanStddev(string2);
            } else {
                this.setMeanStddev(this.defaultMeanStddev());
            }
        } else if (string2.length() != 0) {
            this.setValuesList(string2);
        } else {
            this.setValuesList(this.defaultValuesList());
        }
        string2 = Utils.getOption('N', stringArray);
        if (string2.length() != 0) {
            this.setInstNums(string2);
        } else {
            this.setInstNums(this.defaultMinInstNum() + ".." + this.defaultMaxInstNum());
        }
        if (Utils.getFlag('I', stringArray)) {
            this.setClusterSubType(new SelectedTag(1, SubspaceCluster.TAGS_CLUSTERSUBTYPE));
        } else {
            this.setClusterSubType(new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERSUBTYPE));
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.isRandom()) {
            vector.add("-A");
            vector.add("" + this.getAttrIndexRange());
            vector.add("-D");
            vector.add("" + this.getValuesList());
        } else if (this.isUniform()) {
            vector.add("-U");
            vector.add("" + this.getAttrIndexRange());
            vector.add("-D");
            vector.add("" + this.getValuesList());
        } else if (this.isGaussian()) {
            vector.add("-G");
            vector.add("" + this.getAttrIndexRange());
            vector.add("-D");
            vector.add("" + this.getMeanStddev());
        }
        vector.add("-N");
        vector.add("" + this.getInstNums());
        if (this.m_clustersubtype == 1) {
            vector.add("-I");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String attributesToString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.m_attributes.length; ++i) {
            if (!this.m_attributes[i]) continue;
            if (this.isGaussian()) {
                stringBuffer.append(" Attribute: " + i);
                stringBuffer.append(" Mean: " + this.m_meanValue[n]);
                stringBuffer.append(" StdDev: " + this.m_stddevValue[n] + "\n%");
            } else {
                stringBuffer.append(" Attribute: " + i);
                stringBuffer.append(" Range: " + this.m_minValue[n]);
                stringBuffer.append(" - " + this.m_maxValue[n] + "\n%");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("attributes " + this.attributesToString() + "\n");
        stringBuffer.append("number of instances " + this.getInstNums());
        return stringBuffer.toString();
    }

    public void setParent(SubspaceCluster subspaceCluster) {
        super.setParent(subspaceCluster);
        this.m_AttrIndexRange.setUpper(this.getParent().getNumAttributes());
    }

    protected String defaultAttrIndexRange() {
        return "1";
    }

    public void setAttrIndexRange(String string) {
        this.m_numClusterAttributes = 0;
        if (this.m_AttrIndexRange == null) {
            this.m_AttrIndexRange = new Range();
        }
        this.m_AttrIndexRange.setRanges(string);
        if (this.getParent() != null) {
            int n;
            this.m_AttrIndexRange.setUpper(this.getParent().getNumAttributes());
            this.m_attributes = new boolean[this.getParent().getNumAttributes()];
            for (n = 0; n < this.m_attributes.length; ++n) {
                if (this.m_AttrIndexRange.isInRange(n)) {
                    ++this.m_numClusterAttributes;
                    this.m_attributes[n] = true;
                    continue;
                }
                this.m_attributes[n] = false;
            }
            this.m_attrIndices = new int[this.m_numClusterAttributes];
            n = -1;
            for (int i = 0; i < this.m_attributes.length; ++i) {
                if (!this.m_AttrIndexRange.isInRange(i)) continue;
                this.m_attrIndices[++n] = i;
            }
        }
    }

    public String getAttrIndexRange() {
        return this.m_AttrIndexRange.getRanges();
    }

    public String attrIndexRangeTipText() {
        return "The attribute range(s).";
    }

    public boolean[] getAttributes() {
        return this.m_attributes;
    }

    public double[] getMinValue() {
        return this.m_minValue;
    }

    public double[] getMaxValue() {
        return this.m_maxValue;
    }

    public double[] getMeanValue() {
        return this.m_meanValue;
    }

    public double[] getStddevValue() {
        return this.m_stddevValue;
    }

    public int getNumInstances() {
        return this.m_numInstances;
    }

    protected SelectedTag defaultClusterType() {
        return new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERTYPE);
    }

    public SelectedTag getClusterType() {
        return new SelectedTag(this.m_clustertype, SubspaceCluster.TAGS_CLUSTERTYPE);
    }

    public void setClusterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == SubspaceCluster.TAGS_CLUSTERTYPE) {
            this.m_clustertype = selectedTag.getSelectedTag().getID();
        }
    }

    public String clusterTypeTipText() {
        return "The type of cluster to use.";
    }

    protected SelectedTag defaultClusterSubType() {
        return new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERSUBTYPE);
    }

    public SelectedTag getClusterSubType() {
        return new SelectedTag(this.m_clustersubtype, SubspaceCluster.TAGS_CLUSTERSUBTYPE);
    }

    public void setClusterSubType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == SubspaceCluster.TAGS_CLUSTERSUBTYPE) {
            this.m_clustersubtype = selectedTag.getSelectedTag().getID();
        }
    }

    public String clusterSubTypeTipText() {
        return "The sub-type of cluster to use.";
    }

    public boolean isRandom() {
        return this.m_clustertype == 0;
    }

    public boolean isUniform() {
        return this.m_clustertype == 1;
    }

    public boolean isGaussian() {
        return this.m_clustertype == 2;
    }

    public boolean isContinuous() {
        return this.m_clustertype == 0;
    }

    public boolean isInteger() {
        return this.m_clustertype == 1;
    }

    protected void setInstNums(String string) {
        int n = string.indexOf("..");
        if (n == -1) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        this.m_MinInstNum = Integer.parseInt(string2);
        if (n < string.length()) {
            String string3 = string.substring(n + 2, string.length());
            this.m_MaxInstNum = Integer.parseInt(string3);
        } else {
            this.m_MaxInstNum = this.m_MinInstNum;
        }
    }

    protected String getInstNums() {
        String string = new String("" + this.m_MinInstNum + ".." + this.m_MaxInstNum);
        return string;
    }

    protected String instNumsTipText() {
        return "The lower and upper boundary for the number of instances in this cluster.";
    }

    protected int defaultMinInstNum() {
        return 1;
    }

    public int getMinInstNum() {
        return this.m_MinInstNum;
    }

    public void setMinInstNum(int n) {
        this.m_MinInstNum = n;
    }

    public String minInstNumTipText() {
        return "The lower boundary for instances per cluster.";
    }

    protected int defaultMaxInstNum() {
        return 50;
    }

    public int getMaxInstNum() {
        return this.m_MaxInstNum;
    }

    public void setMaxInstNum(int n) {
        this.m_MaxInstNum = n;
    }

    public String maxInstNumTipText() {
        return "The upper boundary for instances per cluster.";
    }

    public void setNumInstances(Random random) {
        this.m_numInstances = this.m_MaxInstNum > this.m_MinInstNum ? (int)(random.nextDouble() * (double)(this.m_MaxInstNum - this.m_MinInstNum) + (double)this.m_MinInstNum) : this.m_MinInstNum;
    }

    protected String defaultValuesList() {
        return "1,10";
    }

    public void setValuesList(String string) throws Exception {
        this.m_minValue = new double[this.m_numClusterAttributes];
        this.m_maxValue = new double[this.m_numClusterAttributes];
        this.setValuesList(string, this.m_minValue, this.m_maxValue, "D");
        SubspaceCluster subspaceCluster = (SubspaceCluster)this.getParent();
        for (int i = 0; i < this.m_numClusterAttributes; ++i) {
            if (this.m_minValue[i] > this.m_maxValue[i]) {
                throw new Exception("Min must be smaller than max.");
            }
            if (this.getParent() == null) continue;
            if (subspaceCluster.isBoolean(this.m_attrIndices[i])) {
                subspaceCluster.getNumValues()[this.m_attrIndices[i]] = 2;
                if (this.m_minValue[i] != 0.0 && this.m_minValue[i] != 1.0 || this.m_maxValue[i] != 0.0 && this.m_maxValue[i] != 1.0) {
                    throw new Exception("Ranges for boolean must be 0 or 1 only.");
                }
            }
            if (!subspaceCluster.isNominal(this.m_attrIndices[i])) continue;
            double d = this.m_minValue[i] - Math.rint(this.m_minValue[i]);
            if (d != 0.0) {
                throw new Exception(" Ranges for nominal must be integer");
            }
            d = this.m_maxValue[i] - Math.rint(this.m_maxValue[i]);
            if (d != 0.0) {
                throw new Exception("Ranges for nominal must be integer");
            }
            if (this.m_minValue[i] < 0.0) {
                throw new Exception("Range for nominal must start with number 0.0 or higher");
            }
            if (!(this.m_maxValue[i] + 1.0 > (double)subspaceCluster.getNumValues()[this.m_attrIndices[i]])) continue;
            subspaceCluster.getNumValues()[this.m_attrIndices[i]] = (int)this.m_maxValue[i] + 1;
        }
    }

    public String getValuesList() {
        String string = "";
        if (this.m_minValue != null) {
            for (int i = 0; i < this.m_minValue.length; ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + "" + this.m_minValue[i] + "," + this.m_maxValue[i];
            }
        }
        return string;
    }

    public String valuesListTipText() {
        return "The range for each each attribute as string.";
    }

    protected String defaultMeanStddev() {
        return "0,1.0";
    }

    public void setMeanStddev(String string) throws Exception {
        this.m_meanValue = new double[this.m_numClusterAttributes];
        this.m_stddevValue = new double[this.m_numClusterAttributes];
        this.setValuesList(string, this.m_meanValue, this.m_stddevValue, "D");
    }

    public String getMeanStddev() {
        String string = "";
        if (this.m_meanValue != null) {
            for (int i = 0; i < this.m_meanValue.length; ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + "" + this.m_meanValue[i] + "," + this.m_stddevValue[i];
            }
        }
        return string;
    }

    public String meanStddevTipText() {
        return "The mean and stddev, in case of gaussian.";
    }

    public void setValuesList(String string, double[] dArray, double[] dArray2, String string2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != dArray.length + dArray2.length) {
            throw new Exception("Wrong number of values for option '-" + string2 + "'.");
        }
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            dArray[n] = Double.parseDouble(stringTokenizer.nextToken());
            dArray2[n] = Double.parseDouble(stringTokenizer.nextToken());
            ++n;
        }
    }
}

