/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SerializationHelper;
import weka.core.Utils;

public class SerializedClassifier
extends Classifier {
    private static final long serialVersionUID = 4599593909947628642L;
    protected transient Classifier m_Model = null;
    protected File m_ModelFile = new File(System.getProperty("user.dir"));

    public String globalInfo() {
        return "A wrapper around a serialized classifier model. This classifier loads a serialized models and uses it to make predictions.\n\nWarning: since the serialized model doesn't get changed, cross-validation cannot bet used with this classifier.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe file containing the serialized model.\n\t(required)", "model", 1, "-model <filename>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-model");
        vector.add("" + this.getModelFile());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("model", stringArray);
        if (string.length() != 0) {
            this.setModelFile(new File(string));
        } else {
            this.setModelFile(new File(System.getProperty("user.dir")));
        }
    }

    public String modelFileTipText() {
        return "The serialized classifier model to use for predictions.";
    }

    public File getModelFile() {
        return this.m_ModelFile;
    }

    public void setModelFile(File file) {
        this.m_ModelFile = file;
    }

    public void setModel(Classifier classifier) {
        this.m_Model = classifier;
    }

    public Classifier getCurrentModel() {
        return this.m_Model;
    }

    protected void initModel() throws Exception {
        if (this.m_Model == null) {
            this.m_Model = (Classifier)SerializationHelper.read(this.m_ModelFile.getAbsolutePath());
        }
        this.m_Model.setDebug(this.getDebug());
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.m_Model != null ? this.m_Model.getCapabilities() : new Capabilities(this);
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        capabilities.setOwner(this);
        return capabilities;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.initModel();
        double[] dArray = this.m_Model.distributionForInstance(instance);
        return dArray;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.initModel();
        this.getCapabilities().testWithFail(instances);
    }

    public String toString() {
        StringBuffer stringBuffer;
        if (this.m_Model == null) {
            stringBuffer = new StringBuffer("No model loaded yet.");
        } else {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SerializedClassifier\n");
            stringBuffer.append("====================\n\n");
            stringBuffer.append("File: " + this.getModelFile() + "\n\n");
            stringBuffer.append(this.m_Model.toString());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        SerializedClassifier.runClassifier(new SerializedClassifier(), stringArray);
    }
}

