package fr.iri.thd.sonyengine.core;

import java.util.UUID;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;


@Entity
public class Tag {

	@PrimaryKey
	private String id = UUID.randomUUID().toString();
	
	@SecondaryKey(relate=Relationship.MANY_TO_ONE)
	private String name;
	
	@SecondaryKey(relate=Relationship.MANY_TO_ONE, relatedEntity=MovieFragment.class)
	private String segment;


	public String getId() {
		return id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setSegment(String segment) {
		this.segment = segment;
	}

	public String getSegment() {
		return segment;
	}
	
	public Tag(String name, String segment) {
		this.setName(name);
		this.setSegment(segment);
	}
	
	public Tag() {
	}
	
}
