/*
 * Decompiled with CFR 0.152.
 */
package texts;

import core.FFVItem;
import core.TransformableItem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import musigraph.MusiComparator;
import musigraph.MusiGraph;
import musigraph.MusiNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TText
extends FFVItem {
    private static final long serialVersionUID = 6545728727892903989L;
    private static List<String> agidVerbs = new ArrayList<String>();
    private static List<String> agidNouns = new ArrayList<String>();
    private static List<String> agidAds = new ArrayList<String>();
    private static String[] textFeatureNames = new String[]{"nbWords", "nbVerbs", "alliterationFactor"};
    private String text;
    private String[] structure = new String[]{"N", "V", "A"};

    public TText() {
        this.randomize();
    }

    public TText(String s) {
        this.text = s;
    }

    @Override
    public List<TransformableItem> createVariations(int nb) {
        ArrayList<TransformableItem> res = new ArrayList<TransformableItem>(nb);
        int i = 0;
        while ((float)i < this.nbWords()) {
            int cpt = 0;
            while (cpt < (int)((float)nb / this.nbWords())) {
                res.add(this.createVariationAt(i));
                ++cpt;
            }
            ++i;
        }
        return res;
    }

    private TransformableItem createVariationAt(int pos) {
        List<String> words = this.getWords();
        String[] struct = this.getStructure();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((float)i < this.nbWords()) {
            if (i != pos) {
                sb.append(String.valueOf(words.get(i)) + " ");
            } else {
                sb.append(String.valueOf(this.randomWordOfType(struct[pos])) + " ");
            }
            ++i;
        }
        return new TText(sb.toString());
    }

    private List<String> getWords() {
        StringTokenizer st = new StringTokenizer(this.text);
        ArrayList<String> res = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            res.add(st.nextToken());
        }
        return res;
    }

    private String randomWordOfType(String type) {
        if (type.equals("N")) {
            return this.randomWord(agidNouns);
        }
        if (type.equals("V")) {
            return this.randomWord(agidVerbs);
        }
        if (type.equals("A")) {
            return this.randomWord(agidAds);
        }
        return null;
    }

    private String[] getStructure() {
        return this.structure;
    }

    public static void main(String[] args) {
        TText.initializeAgid();
        int i = 0;
        while (i < 20) {
            System.out.println("" + new TText());
            ++i;
        }
    }

    public static void initializeAgid() {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader("infl.txt"));
            while ((str = in.readLine()) != null) {
                TText.readLine(str);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        String w = st.nextToken();
        String type = st.nextToken();
        if (type.equals("N:")) {
            agidNouns.add(w);
            return;
        }
        if (type.equals("N?:")) {
            agidNouns.add(w);
            return;
        }
        if (type.equals("V:")) {
            agidVerbs.add(w);
            return;
        }
        if (type.equals("V?:")) {
            agidVerbs.add(w);
            return;
        }
        if (type.equals("A:")) {
            agidAds.add(w);
            return;
        }
        if (type.equals("A?:")) {
            agidAds.add(w);
            return;
        }
        System.out.println("unknown type: " + type);
    }

    @Override
    public float getFeature(String f) {
        if (f.startsWith("nbWords")) {
            return this.nbWords();
        }
        if (f.startsWith("alliterationFactor")) {
            return this.alliterationFactor();
        }
        return 0.0f;
    }

    private float alliterationFactor() {
        MusiGraph g = new MusiGraph();
        g.clear();
        MusiNode.Clear();
        g.setComparator(new MusiComparator());
        ArrayList<String> v = new ArrayList<String>();
        for (String p : this.getLetterList()) {
            v.add(p);
        }
        g.parseVector(v);
        return g.getCompressibilityRatio();
    }

    private List<String> getLetterList() {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < this.text.length()) {
            res.add("" + this.text.charAt(i));
            ++i;
        }
        return res;
    }

    private float nbWords() {
        return new StringTokenizer(this.text).countTokens();
    }

    @Override
    public String[] getFeatureNames() {
        return textFeatureNames;
    }

    @Override
    protected void randomize() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.randomWord(agidNouns));
        sb.append(" ");
        sb.append(this.randomWord(agidVerbs));
        sb.append(" ");
        sb.append(this.randomWord(agidAds));
        this.text = sb.toString();
    }

    private String randomWord(List<String> l) {
        return l.get((int)(Math.random() * (double)l.size()));
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public CharSequence CSVString(DefaultListModel items) {
        return null;
    }

    @Override
    public void initFromCSV(String[] feats) {
    }
}

