/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Annotation;
import core.MySMO;
import core.TransformableItem;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.classifiers.Classifier;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends Annotation
implements Serializable {
    private static final long serialVersionUID = -2934337599585977993L;
    private static final int ONECLASS_SVM = 2;
    private static final int RBF_KERNEL = 2;
    private static List<Tag> all = new ArrayList<Tag>();
    protected List<TransformableItem> positiveExamples = new ArrayList<TransformableItem>();
    protected List<TransformableItem> negativeExamples = new ArrayList<TransformableItem>();
    private List<TransformableItem> badNegativeExamples = new ArrayList<TransformableItem>();
    protected Classifier classifier = null;
    protected Instances instances = null;
    private AttributeSelection attributeSelector;
    private int nbAttributesSelected = 4;
    private Tag negativeTag;

    public Object readResolve() throws ObjectStreamException {
        Tag t = Tag.getTagNamed(this.name);
        if (t == null) {
            all.add(this);
        }
        return Tag.getTagNamed(this.name);
    }

    public static void clear() {
        all.clear();
    }

    public static List<Tag> getAllTags() {
        return all;
    }

    protected Tag(String n) {
        this.name = n;
        all.add(this);
    }

    public static Tag named(String n) {
        Tag t = Tag.getTagNamed(n);
        if (t != null) {
            return t;
        }
        return new Tag(n);
    }

    protected static Tag getTagNamed(String s) {
        for (Tag t : all) {
            if (!t.getName().equalsIgnoreCase(s)) continue;
            return t;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.positiveExamples.size() + "/" + this.negativeExamples.size() + ")";
    }

    public boolean isNamed(String tag) {
        return this.name.equals(tag);
    }

    public static void clearAllClassifiersAndTrainingSets() {
        for (Tag t : all) {
            t.clearClassifierAndTrainingSet();
        }
    }

    public void clearClassifierAndTrainingSet() {
        this.classifier = null;
        this.instances = null;
        this.positiveExamples.clear();
        this.negativeExamples.clear();
    }

    public void train() {
        this.classifier = null;
        if (!this.isTrainingSetOk()) {
            System.out.println("tag " + this + " has bad training set, cannot be trained");
            return;
        }
        this.classifier = this.createLearningModel();
        FastVector columns = this.buildColumns();
        this.instances = new Instances(this.name, columns, 10);
        for (TransformableItem m : this.positiveExamples) {
            this.instances.add(this.getInstanceFor(m));
        }
        for (TransformableItem m : this.negativeExamples) {
            this.instances.add(this.getInstanceFor(m));
        }
        this.instances.setClassIndex(columns.size() - 1);
        this.instances = this.featureSelection(this.instances);
        try {
            this.classifier.buildClassifier(this.instances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Instances featureSelection(Instances inst) {
        this.attributeSelector = new AttributeSelection();
        Ranker rank = new Ranker();
        rank.setNumToSelect(this.nbAttributesSelected);
        this.attributeSelector.setSearch((ASSearch)rank);
        this.attributeSelector.setEvaluator((ASEvaluation)new InfoGainAttributeEval());
        try {
            this.attributeSelector.SelectAttributes(inst);
            return this.attributeSelector.reduceDimensionality(inst);
        }
        catch (Exception e) {
            System.out.println("error with " + this);
            e.printStackTrace();
            return inst;
        }
    }

    protected Classifier createLearningModel() {
        MySMO c = new MySMO();
        RBFKernel kernel = new RBFKernel();
        c.setKernel((Kernel)kernel);
        c.setBuildLogisticModels(true);
        return c;
    }

    private FastVector buildColumns() {
        String[] fNames;
        FastVector columns = new FastVector();
        String[] stringArray = fNames = this.positiveExamples.get(0).getFeatureNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String featureName = stringArray[n];
            Attribute attr = new Attribute(featureName);
            columns.addElement((Object)attr);
            ++n;
        }
        FastVector falseTrue = new FastVector();
        falseTrue.addElement((Object)"false");
        falseTrue.addElement((Object)"true");
        columns.addElement((Object)new Attribute(this.name, falseTrue));
        return columns;
    }

    public void addPositiveExample(TransformableItem m) {
        this.positiveExamples.add(m);
    }

    public void addNegativeExample(TransformableItem m) {
        this.negativeExamples.add(m);
    }

    public void addBadNegativeExample(TransformableItem m) {
        this.badNegativeExamples.add(m);
    }

    public boolean isTrainingSetOk() {
        if (this.positiveExamples.size() < 3) {
            return false;
        }
        if (this.negativeExamples.size() < 3) {
            return false;
        }
        if (Math.abs(this.negativeExamples.size() / this.positiveExamples.size()) > 10) {
            return false;
        }
        return Math.abs(this.positiveExamples.size() / this.negativeExamples.size()) <= 10;
    }

    public double classify(TransformableItem m) {
        if (this.classifier == null) {
            return 0.0;
        }
        try {
            Instance inst = this.getInstanceFor(m);
            inst = this.attributeSelector.reduceDimensionality(inst);
            inst.setDataset(this.instances);
            return this.classifier.classifyInstance(inst);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return 0.0;
        }
    }

    public double classifyScalar(TransformableItem m) {
        if (this.classifier == null) {
            return 0.0;
        }
        try {
            Instance inst = this.getInstanceFor(m);
            inst.setDataset(this.instances);
            inst = this.attributeSelector.reduceDimensionality(inst);
            double[] distrib = this.classifier.distributionForInstance(inst);
            return distrib[1];
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return 0.0;
        }
    }

    private Instance getInstanceFor(TransformableItem motive) {
        if (motive == null) {
            System.out.println("probleme ici");
        }
        Instance inst = new Instance(motive.getNbFeatures() + 1);
        int i = 0;
        while (i < motive.getNbFeatures()) {
            inst.setValue(i, (double)motive.getFeatureAt(i));
            ++i;
        }
        if (motive.hasTag(this)) {
            inst.setValue(motive.getNbFeatures(), 1.0);
        } else {
            inst.setValue(motive.getNbFeatures(), 0.0);
        }
        return inst;
    }

    public List<TransformableItem> getExamples() {
        ArrayList<TransformableItem> res = new ArrayList<TransformableItem>();
        res.addAll(this.positiveExamples);
        res.addAll(this.negativeExamples);
        return res;
    }

    public boolean hasAsExample(TransformableItem m) {
        if (this.positiveExamples.contains(m)) {
            return true;
        }
        return this.negativeExamples.contains(m);
    }

    public int getNbExamples() {
        return this.positiveExamples.size() + this.negativeExamples.size();
    }

    public int getNbPositiveExamples() {
        return this.positiveExamples.size();
    }

    public int getNbNegativeExamples() {
        return this.negativeExamples.size();
    }

    public List<TransformableItem> getPositiveExamples() {
        return this.positiveExamples;
    }

    public List<TransformableItem> getNegativeExamples() {
        return this.negativeExamples;
    }

    public float getSvmOutput(TransformableItem m) {
        if (m == null) {
            return 0.0f;
        }
        if (this.classifier == null) {
            return 0.0f;
        }
        Instance i1 = this.getInstanceFor(m);
        i1.setDataset(this.instances);
        Instance i2 = ((MySMO)this.classifier).normalize(i1, this.instances);
        try {
            return (float)((MySMO)this.classifier).getClassifier()[0][1].SVMOutput(-1, i2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public String getSelectedFeatures() {
        if (this.attributeSelector == null) {
            return "no info yet. Need to train";
        }
        String res = this.attributeSelector.toResultsString();
        int a = res.indexOf("Ranked attributes:");
        int b = res.indexOf("Selected attributes:");
        return res.substring(a + 19, b);
    }

    public boolean acceptAsNegativeExample(TransformableItem m) {
        return !this.badNegativeExamples.contains(m);
    }

    @Override
    public double valueFor(TransformableItem it) {
        return this.classifyScalar(it);
    }

    public void setNegativeTag(Tag negTag) {
        this.negativeTag = negTag;
    }

    public Tag getNegativeTag() {
        return this.negativeTag;
    }

    public static int getAllTagSize() {
        return all.size();
    }

    public static Tag tagAt(int i) {
        return all.get(i);
    }

    public int getNbAttributesSelected() {
        return this.nbAttributesSelected;
    }

    public void setNbAttributesSelected(int nbAttributesSelected) {
        this.nbAttributesSelected = nbAttributesSelected;
    }
}

