/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Tag;
import core.TagConstraint;
import core.TransformableItemFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConstrainAttributeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JList tagConstraintjList = null;
    private JButton okjButton = null;
    private JButton canceljButton = null;
    private JPanel jPanel1 = null;
    protected boolean cancel = false;
    private TransformableItemFrame myFrame;
    private DefaultListModel tagConstraints = new DefaultListModel();
    private JPanel jPanel5 = null;
    private JRadioButton morejRadioButton1 = null;
    private JRadioButton lessjRadioButton2 = null;
    private JPanel jPanel6 = null;
    private JTextField precisionjTextField = null;
    private JSlider precisionjSlider = null;
    private JRadioButton asjRadioButton = null;
    private ButtonGroup buttonGroup = null;
    private JScrollPane jScrollPane = null;
    private JRadioButton dontCarejRadioButton;

    public ConstrainAttributeDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public ConstrainAttributeDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.myFrame = (TransformableItemFrame)owner;
        this.initialize();
    }

    public ConstrainAttributeDialog(Frame owner, boolean modal, DefaultListModel initialCtSet) {
        super(owner, modal);
        this.myFrame = (TransformableItemFrame)owner;
        this.initialize();
        this.initContraintSet(initialCtSet);
    }

    public boolean wasCancelled() {
        return this.cancel;
    }

    public DefaultListModel getConstraints() {
        return this.tagConstraints;
    }

    private void initialize() {
        this.setSize(430, 167);
        this.setTitle("Specify Constraints on Descriptors");
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConstrainAttributeDialog.this.cancel = true;
            }
        });
    }

    public void initContraintSet(DefaultListModel cs) {
        int i = 0;
        while (i < this.myFrame.getTags().size()) {
            this.tagConstraints.addElement(new TagConstraint((Tag)this.myFrame.getTags().elementAt(i), 3, 10));
            ++i;
        }
        if (cs == null) {
            return;
        }
        if (cs.size() != this.tagConstraints.size()) {
            return;
        }
        i = 0;
        while (i < this.tagConstraints.size()) {
            TagConstraint tc = (TagConstraint)this.tagConstraints.elementAt(i);
            TagConstraint ref = (TagConstraint)cs.elementAt(i);
            tc.setConstraintType(ref.getConstraintType());
            tc.setRatio(ref.getRatio());
            ++i;
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridheight = 3;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 2;
            gridBagConstraints21.weightx = 0.5;
            gridBagConstraints21.gridy = 3;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanel1(), gridBagConstraints21);
            this.jContentPane.add((Component)this.getJPanel5(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JList getTagConstraintjList() {
        if (this.tagConstraintjList == null) {
            this.tagConstraintjList = new JList();
            this.tagConstraintjList.setModel(this.tagConstraints);
            this.tagConstraintjList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ConstrainAttributeDialog.this.selectTagConstraint(ConstrainAttributeDialog.this.tagConstraintjList.getSelectedValue());
                }
            });
        }
        return this.tagConstraintjList;
    }

    protected void selectTagConstraint(Object obj) {
        if (obj == null) {
            return;
        }
        TagConstraint tc = (TagConstraint)obj;
        if (tc.getConstraintType() == 0) {
            this.asjRadioButton.setSelected(true);
        }
        if (tc.getConstraintType() == 1) {
            this.morejRadioButton1.setSelected(true);
        }
        if (tc.getConstraintType() == 2) {
            this.lessjRadioButton2.setSelected(true);
        }
        this.precisionjSlider.setValue(tc.getRatio());
        this.precisionjTextField.setText(this.precisionjSlider.getValue() + "%");
    }

    protected void setSelectedTagConstraintTo(int ctType) {
        int i = this.tagConstraintjList.getSelectedIndex();
        if (i < 0) {
            return;
        }
        TagConstraint tc = (TagConstraint)this.tagConstraintjList.getSelectedValue();
        tc.setConstraintType(ctType);
        this.tagConstraintjList.revalidate();
        this.tagConstraintjList.repaint();
    }

    private JButton getOkjButton() {
        if (this.okjButton == null) {
            this.okjButton = new JButton();
            this.okjButton.setText("OK");
            this.okjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConstrainAttributeDialog.this.cancel = false;
                    ConstrainAttributeDialog.this.setVisible(false);
                }
            });
        }
        return this.okjButton;
    }

    private JButton getCanceljButton() {
        if (this.canceljButton == null) {
            this.canceljButton = new JButton();
            this.canceljButton.setText("cancel");
            this.canceljButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConstrainAttributeDialog.this.cancel = true;
                    ConstrainAttributeDialog.this.setVisible(false);
                }
            });
        }
        return this.canceljButton;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = -1;
            gridBagConstraints6.gridy = -1;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getOkjButton(), gridBagConstraints6);
            this.jPanel1.add((Component)this.getCanceljButton(), gridBagConstraints7);
        }
        return this.jPanel1;
    }

    protected boolean hasSelectedTC() {
        return this.tagConstraintjList.getSelectedIndex() >= 0;
    }

    protected TagConstraint getSelectedTC() {
        int i = this.tagConstraintjList.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return (TagConstraint)this.tagConstraintjList.getSelectedValue();
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.getJPanel6(), gridBagConstraints);
        }
        return this.jPanel5;
    }

    private JRadioButton getMorejRadioButton1() {
        if (this.morejRadioButton1 == null) {
            JToggleButton.ToggleButtonModel toggleButtonModel1 = new JToggleButton.ToggleButtonModel();
            toggleButtonModel1.setGroup(this.getButtonGroup());
            this.morejRadioButton1 = new JRadioButton();
            this.morejRadioButton1.setText("more");
            this.morejRadioButton1.setModel(toggleButtonModel1);
            this.morejRadioButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConstrainAttributeDialog.this.setSelectedTagConstraintTo(1);
                }
            });
        }
        return this.morejRadioButton1;
    }

    private JRadioButton getLessjRadioButton2() {
        if (this.lessjRadioButton2 == null) {
            JToggleButton.ToggleButtonModel toggleButtonModel2 = new JToggleButton.ToggleButtonModel();
            toggleButtonModel2.setGroup(this.getButtonGroup());
            this.lessjRadioButton2 = new JRadioButton();
            this.lessjRadioButton2.setText("less");
            this.lessjRadioButton2.setModel(toggleButtonModel2);
            this.getButtonGroup().add(this.lessjRadioButton2);
            this.lessjRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConstrainAttributeDialog.this.setSelectedTagConstraintTo(2);
                }
            });
        }
        return this.lessjRadioButton2;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 0;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 1;
            gridBagConstraints23.gridy = 2;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.gridwidth = 3;
            gridBagConstraints23.gridx = 0;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridy = 1;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.gridwidth = 3;
            gridBagConstraints22.gridx = 0;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 2;
            gridBagConstraints20.gridy = 0;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.gridy = 0;
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new GridBagLayout());
            this.jPanel6.setPreferredSize(new Dimension(300, 60));
            this.jPanel6.add((Component)this.getMorejRadioButton1(), gridBagConstraints17);
            this.jPanel6.add((Component)this.getLessjRadioButton2(), gridBagConstraints20);
            this.jPanel6.add((Component)this.getPrecisionjTextField(), gridBagConstraints22);
            this.jPanel6.add((Component)this.getPrecisionjSlider(), gridBagConstraints23);
            this.jPanel6.add((Component)this.getAsjRadioButton(), gridBagConstraints13);
            this.jPanel6.add((Component)this.getDontCarejRadioButton(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.jPanel6;
    }

    private JTextField getPrecisionjTextField() {
        if (this.precisionjTextField == null) {
            this.precisionjTextField = new JTextField();
            this.precisionjTextField.setText("10%");
            this.precisionjTextField.setPreferredSize(new Dimension(100, 20));
        }
        return this.precisionjTextField;
    }

    private JSlider getPrecisionjSlider() {
        if (this.precisionjSlider == null) {
            this.precisionjSlider = new JSlider();
            this.precisionjSlider.setValue(10);
            this.precisionjSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ConstrainAttributeDialog.this.precisionjTextField.setText(ConstrainAttributeDialog.this.precisionjSlider.getValue() + "%");
                    if (ConstrainAttributeDialog.this.hasSelectedTC()) {
                        ConstrainAttributeDialog.this.getSelectedTC().setRatio(ConstrainAttributeDialog.this.precisionjSlider.getValue());
                        ConstrainAttributeDialog.this.tagConstraintjList.revalidate();
                        ConstrainAttributeDialog.this.tagConstraintjList.repaint();
                    }
                }
            });
        }
        return this.precisionjSlider;
    }

    private JRadioButton getAsjRadioButton() {
        if (this.asjRadioButton == null) {
            JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
            toggleButtonModel.setGroup(this.getButtonGroup());
            this.asjRadioButton = new JRadioButton();
            this.asjRadioButton.setText("as");
            this.asjRadioButton.setModel(toggleButtonModel);
            this.asjRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConstrainAttributeDialog.this.setSelectedTagConstraintTo(0);
                }
            });
        }
        return this.asjRadioButton;
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTagConstraintjList());
        }
        return this.jScrollPane;
    }

    private JRadioButton getDontCarejRadioButton() {
        if (this.dontCarejRadioButton == null) {
            this.dontCarejRadioButton = new JRadioButton();
            this.dontCarejRadioButton.setText("?");
            this.getButtonGroup().add(this.dontCarejRadioButton);
            this.dontCarejRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ConstrainAttributeDialog.this.setSelectedTagConstraintTo(3);
                }
            });
        }
        return this.dontCarejRadioButton;
    }
}

