/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.meta.AdaBoostM1;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MultiBoostAB
extends AdaBoostM1
implements TechnicalInformationHandler {
    static final long serialVersionUID = -6681619178187935148L;
    protected int m_NumSubCmtys = 3;
    protected Random m_Random = null;

    public String globalInfo() {
        return "Class for boosting a classifier using the MultiBoosting method.\n\nMultiBoosting is an extension to the highly successful AdaBoost technique for forming decision committees. MultiBoosting can be viewed as combining AdaBoost with wagging. It is able to harness both AdaBoost's high bias and variance reduction with wagging's superior variance reduction. Using C4.5 as the base learning algorithm, Multi-boosting is demonstrated to produce decision committees with lower error than either AdaBoost or wagging significantly more often than the reverse over a large representative cross-section of UCI data sets. It offers the further advantage over AdaBoost of suiting parallel execution.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Geoffrey I. Webb");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "MultiBoosting: A Technique for Combining Boosting and Wagging");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "Vol.40");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "No.2");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Kluwer Academic Publishers");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Boston");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Enumeration enumeration = super.listOptions();
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tNumber of sub-committees. (Default 3)", "C", 1, "-C <num>"));
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setNumSubCmtys(Integer.parseInt(string));
        } else {
            this.setNumSubCmtys(3);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = "-C";
        stringArray2[1] = "" + this.getNumSubCmtys();
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        return stringArray2;
    }

    public String numSubCmtysTipText() {
        return "Sets the (approximate) number of subcommittees.";
    }

    public void setNumSubCmtys(int n) {
        this.m_NumSubCmtys = n;
    }

    public int getNumSubCmtys() {
        return this.m_NumSubCmtys;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_Random = new Random(this.m_Seed);
        super.buildClassifier(instances);
        this.m_Random = null;
    }

    protected void setWeights(Instances instances, double d) throws Exception {
        int n = this.m_Classifiers.length / this.m_NumSubCmtys;
        if ((this.m_NumIterationsPerformed + 1) % n == 0) {
            if (this.getDebug()) {
                System.err.println(this.m_NumIterationsPerformed + " " + n);
            }
            double d2 = instances.sumOfWeights();
            for (int i = 0; i < instances.numInstances(); ++i) {
                instances.instance(i).setWeight(-Math.log(this.m_Random.nextDouble() * 9999.0 / 10000.0));
            }
            double d3 = instances.sumOfWeights();
            for (int i = 0; i < instances.numInstances(); ++i) {
                instances.instance(i).setWeight(instances.instance(i).weight() * d2 / d3);
            }
        } else {
            super.setWeights(instances, d);
        }
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_NumIterations == 0) {
            stringBuffer.append("MultiBoostAB: No model built yet.\n");
        } else if (this.m_NumIterations == 1) {
            stringBuffer.append("MultiBoostAB: No boosting possible, one classifier used!\n");
            stringBuffer.append(this.m_Classifiers[0].toString() + "\n");
        } else {
            stringBuffer.append("MultiBoostAB: Base classifiers and their weights: \n\n");
            for (int i = 0; i < this.m_NumIterations; ++i) {
                if (this.m_Classifiers != null && this.m_Classifiers[i] != null) {
                    stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
                    stringBuffer.append("Weight: " + Utils.roundDouble(this.m_Betas[i], 2) + "\n\n");
                    continue;
                }
                stringBuffer.append("not yet initialized!\n\n");
            }
            stringBuffer.append("Number of performed Iterations: " + this.m_NumIterations + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        MultiBoostAB.runClassifier(new MultiBoostAB(), stringArray);
    }
}

