package fr.iri.thd.sonyengine.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.MediaType;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import com.sleepycat.persist.EntityIndex;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;

import fr.iri.thd.sonyengine.core.DataAccessor;
import fr.iri.thd.sonyengine.core.DbEnv;

public class TestEngineAccessor {

    public static final String BASE_URL = "http://localhost:9080/sonyengine/";
    public static final String DATABASE_PATH = "/Users/ymh/dev/tmp/db";

    private DbEnv dbenv = null;
    private File databasePathFile = null;
    private String baseurl = null;
            
    @Before
    public void setup()
    {
        String databasepath = System.getProperty("database_path");
        if(databasepath == null)
            databasepath = DATABASE_PATH;
        databasePathFile = new File(databasepath);
        
        this.baseurl = System.getProperty("baseurl");
        if(this.baseurl == null)
            this.baseurl = BASE_URL;
    }
    
    @After
    public void teardown() {
    
        if(dbenv != null)
            dbenv.close();
    }
    
    @Test
    public void testUntrainedBelowLimit() {
        
        Client c = Client.create();
        WebResource res = c.resource(this.baseurl);
        String response = res.path("engine").path("reset").accept(MediaType.TEXT_PLAIN).post(String.class);
        
        Assert.assertEquals(response, "ok");
        
        String movieName = "movie" + System.currentTimeMillis();
        
        List<String> tagNames = new ArrayList<String>();
        
        for(int i=0; i< 4; i++) {
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            tagNames.add("tag" + System.currentTimeMillis());
        }
        
        res = c.resource(this.baseurl + "segment/create/" + movieName);
        response = res.accept(MediaType.APPLICATION_XML_TYPE).post(String.class);
                
        Assert.assertNotNull(response);
        
        String xml = "<tags>";
        for(String tagName: tagNames) {
            xml += String.format("<tag name=\"%s\" segment=\"%s\"/>", tagName, movieName);
        }
        xml += "</tags>";
        
        res = c.resource(this.baseurl).path("tag").path("add");
        Form form = new Form();
        form.add("xml", xml);
        response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.APPLICATION_XML_TYPE).post(String.class, form);

        Assert.assertNotNull(response);

        dbenv = new DbEnv();
        dbenv.setup(databasePathFile, true, true);

        DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());
        
        final EntityIndex<String, fr.iri.thd.sonyengine.core.Tag> ei = da.tagByTrained.subIndex(Boolean.FALSE);
        Assert.assertEquals(4l, ei.count());
        
    }

    @Test
    public void testUntrainedOverLimit() {
        
        String movieName = "movie" + System.currentTimeMillis();
        
        List<String> tagNames = new ArrayList<String>();
        
        for(int i=0; i< 6; i++) {
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            tagNames.add("tag" + System.currentTimeMillis());
        }
        
        Client c = Client.create();
        WebResource res = c.resource(this.baseurl + "segment/create/" + movieName);
        String response = res.accept(MediaType.APPLICATION_XML_TYPE).post(String.class);
                
        Assert.assertNotNull(response);
        
        String xml = "<tags>";
        for(String tagName: tagNames) {
            xml += String.format("<tag name=\"%s\" segment=\"%s\"/>", tagName, movieName);
        }
        xml += "</tags>";
        
        res = c.resource(this.baseurl).path("tag").path("add");
        Form form = new Form();
        form.add("xml", xml);
        response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.APPLICATION_XML_TYPE).post(String.class, form);

        Assert.assertNotNull(response);
                
        res = c.resource(this.baseurl).path("segment").path("cleartags").path(movieName);
        response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.TEXT_PLAIN).post(String.class);
        
        Assert.assertEquals("ok", response);

        dbenv = new DbEnv();
        dbenv.setup(databasePathFile, true, true);

        DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());
                
        Assert.assertFalse(da.tagBySegment.contains(movieName));
        
        final EntityIndex<String, fr.iri.thd.sonyengine.core.Tag> ei = da.tagByTrained.subIndex(Boolean.FALSE);
        Assert.assertEquals(0l, ei.count());
        
    }

    
}
