package fr.iri.thd.sonyengine.test;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sleepycat.persist.EntityCursor;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;

import fr.iri.thd.sonyengine.core.DataAccessor;
import fr.iri.thd.sonyengine.core.DbEnv;

/*
 * 
 * import java.io.File;

import core.Tag;

/**
 * A class to test ThdEngine
 *
 * @author pachet
 *
public class ThdEngineTest {

 public static void main(String[] args) {
 testSimpleExampleManual();
//   testSimpleExampleFile();
 // testUniversCineFile();
 }

 /**
 * Tests the engine with a small set of movies and tags, entered
"manually", one by one
 private static void testSimpleExampleManual() {
 ThdEngine engine = ThdEngine.getEngine();
 engine.createMovieFragment("ref1");
 engine.createMovieFragment("ref2");
 engine.createMovieFragment("ref3");
 engine.createMovieFragment("ref4");
 engine.createMovieFragment("ref5");
 engine.createMovieFragment("ref6");
 engine.createMovieFragment("ref7");

 engine.addTag("crayon", "ref1");
 engine.addTag("carte", "ref1");
 engine.addTag("bateau", "ref1");
 engine.addTag("voiture", "ref1");
 engine.addTag("car", "ref1");

 engine.addTag("enfant", "ref2");
 engine.addTag("famille", "ref2");
 engine.addTag("violon", "ref2");
 engine.addTag("maison", "ref2");
 engine.addTag("hopital", "ref2");

 engine.addTag("enfant", "ref3");
 engine.addTag("famille", "ref3");
 engine.addTag("violon", "ref3");
 engine.addTag("maison", "ref3");
 engine.addTag("ordinateur", "ref3");
 engine.addTag("fenetre", "ref3");
 engine.addTag("voiture", "ref3");
 engine.addTag("guitare", "ref3");
 engine.addTag("carte", "ref3");

 engine.addTag("enfant", "ref4");
 engine.addTag("famille", "ref4");
 engine.addTag("violon", "ref4");
 engine.addTag("bateau", "ref4");
 engine.addTag("ordinateur", "ref4");
 engine.addTag("fenetre", "ref4");
 engine.addTag("stylo", "ref4");
 engine.addTag("perroquet", "ref4");
 engine.addTag("crayon", "ref4");
 engine.addTag("tele", "ref4");
 engine.addTag("bateau", "ref4");

 engine.addTag("ordinateur", "ref5");
 engine.addTag("crayon", "ref5");
 engine.addTag("fenetre", "ref5");
 engine.addTag("hopital", "ref5");
 engine.addTag("carte", "ref5");
 engine.addTag("tele", "ref5");
 engine.addTag("stylo", "ref5");
 engine.addTag("perroquet", "ref5");
 engine.addTag("bateau", "ref5");
 engine.addTag("guitare", "ref5");

 engine.addTag("maison", "ref6");
 engine.addTag("perroquet", "ref6");
 engine.addTag("stylo", "ref6");
 engine.addTag("guitare", "ref6");
 engine.addTag("hopital", "ref6");
 engine.addTag("tele", "ref6");
 engine.addTag("car", "ref6");
 engine.addTag("voiture", "ref6");
 engine.addTag("fenetre", "ref6");

 engine.addTag("car", "ref7");
 engine.addTag("voiture", "ref7");

 engine.reTrain();
 engine.showAllTagValues();

 //Neighbor neighbor = engine.findMore("ref1", "enfant", .05f, true);

 while (neighbor != null) {
  System.out.println(neighbor.getMovieRef() + " distance: "
    + neighbor.getDistance());
  neighbor = engine.findMore(neighbor.getMovieRef(), "enfant", .05f,
    true);
 }
 System.out.println("cannot find any better");
 }

 /**
 * Tests the engine with a xcl file containing references of movies and
 * their tags. esult should be the same than testSimpleExampleManual()
 public static void testSimpleExampleFile() {
 ThdEngine engine = ThdEngine.getEngine();
 engine.loadFromTextFile(new File("./Sessions/Essai.csv"));
 System.out.println("number of movies read: "
   + engine.getAllMovieFragments().size());

 engine.reTrain();
 engine.showAllTagValues();

 Neighbor neighbor = engine.findMore("ref1", "enfant", .05f, true);

 while (neighbor != null) {
  System.out.println(neighbor.getMovieRef() + " distance: "
    + neighbor.getDistance());
  neighbor = engine.findMore(neighbor.getMovieRef(), "enfant", .05f,
    true);
 }
 System.out.println("cannot find any better");
 }

 /**
 * Tests the engine with a xcl file containing references of movies and
 * their tags
 public static void testUniversCineFile() {
 ThdEngine engine = ThdEngine.getEngine();
 engine.loadFromTextFile(new File("./Sessions/MovieFrame2.csv"));
 System.out.println("number of movies read: "
   + engine.getAllMovieFragments().size());
 ThdMovieFragment sobibor = engine
   .movieFragmentNamed("Sobibor, 14 octobre 1943, 16 heures");
 engine.reTrain();

 Tag T_enfant = engine.tagNamed("Enfant");
 System.out.println(sobibor);
 System.out.println(T_enfant);

 engine.tagNamed("Enfant").valueFor(sobibor);

 Neighbor neighbor = engine.findMore(sobibor.getName(), "Enfant", .05f,
   true);

 while (neighbor != null) {
  System.out.println(neighbor.getMovieRef() + " distance: "
    + neighbor.getDistance());
  neighbor = engine.findMore(neighbor.getMovieRef(), "Enfant", .05f,
    true);
 }
 System.out.println("cannot find any better");
 }

}

 * 
 * 
 * 
 * 
 * 
 */



public class TestEngine {

	public static final String BASE_URL = "http://localhost:8080/mosatags.sonyengine/";
	public static final String DATABASE_PATH = "/Users/ymh/dev/tmp/db";

	private DbEnv dbenv = null;
	private File databasePathFile = null;
			
	@Before
	public void setup()
	{
		String databasepath = System.getProperty("database_path");
		if(databasepath == null)
			databasepath = DATABASE_PATH;
		databasePathFile = new File(databasepath);
	}
	
	@After
	public void teardown() {
	
		if(dbenv != null)
			dbenv.close();
	}
	
	@Test
	public void testCreateMovieFragment() {
				
		String movieName = "movie" + System.currentTimeMillis();
		
		Client c = Client.create();
		WebResource res = c.resource(BASE_URL + "segment/create/" + movieName);
		
		String response = res.accept(MediaType.APPLICATION_XML_TYPE).post(String.class);
				
		Assert.assertNotNull(response);
		
		
		dbenv = new DbEnv();
		dbenv.setup(databasePathFile, true, true);

		DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());

		
		EntityCursor<String> cursor = da.movieFragmentById.keys();
		
		for (String key : cursor) {
			Assert.assertNotNull(key);
		}
		
		cursor.close();
		
		Assert.assertTrue(da.movieFragmentById.contains(movieName));
		
	}

	@Test
	public void testCreateMovieFragmentForm() {
				
		String movieName = "movie" + System.currentTimeMillis();
		
		Client c = Client.create();
		
		Form form = new Form();
		form.add("id", movieName);
		
		WebResource res = c.resource(BASE_URL + "segment/create");		

		String response = res.type(MediaType.APPLICATION_FORM_URLENCODED).post(String.class, form);
				
		Assert.assertNotNull(response);
		
		dbenv = new DbEnv();
		dbenv.setup(databasePathFile, true, true);

		DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());

		
		EntityCursor<String> cursor = da.movieFragmentById.keys();
		
		for (String key : cursor) {
			Assert.assertNotNull(key);
		}
		
		cursor.close();
		
		Assert.assertTrue(da.movieFragmentById.contains(movieName));
		
	}

	
	@Test
	public void testCreateTag() {

		String movieName = "movie" + System.currentTimeMillis();
		String tagName = "tag" + System.currentTimeMillis();;
		
		Client c = Client.create();
		WebResource res = c.resource(BASE_URL + "segment/create/" + movieName);
		String response = res.accept(MediaType.APPLICATION_JSON_TYPE).post(String.class);
				
		Assert.assertNotNull(response);
		
		res = c.resource(BASE_URL).path("tag").path("add").path(tagName).path(movieName);
		response = res.accept(MediaType.APPLICATION_JSON_TYPE).post(String.class);

		Assert.assertNotNull(response);

		dbenv = new DbEnv();
		dbenv.setup(databasePathFile, true, true);

		DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());
		
		Assert.assertTrue(da.tagByName.contains(tagName));
		
	}

	@Test
	public void testCreateTagList() {

		String movieName = "movie" + System.currentTimeMillis();
		
		List<String> tagNames = new ArrayList<String>();
		
		for(int i=0; i< 10; i++) {
			try {
				Thread.sleep(1);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			tagNames.add("tag" + System.currentTimeMillis());
		}
		
		Client c = Client.create();
		WebResource res = c.resource(BASE_URL + "segment/create/" + movieName);
		String response = res.accept(MediaType.APPLICATION_XML_TYPE).post(String.class);
				
		Assert.assertNotNull(response);
		
		String xml = "<tags>";
		for(String tagName: tagNames) {
			xml += String.format("<tag name=\"%s\" segment=\"%s\"/>", tagName, movieName);
		}
		xml += "</tags>";
		
		res = c.resource(BASE_URL).path("tag").path("add");
		Form form = new Form();
		form.add("xml", xml);
		response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.APPLICATION_XML_TYPE).post(String.class, form);

		Assert.assertNotNull(response);

		dbenv = new DbEnv();
		dbenv.setup(databasePathFile, true, true);

		DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());
		
		for(String tagName: tagNames) {		
			Assert.assertTrue(da.tagByName.contains(tagName));
		}
		
	}
	
	@Test
	public void testCreateSequenceList() {

		List<String> movieIds = new ArrayList<String>();
		
		for(int i=0; i< 10; i++) {
			try {
				Thread.sleep(1);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			movieIds.add("movie" + System.currentTimeMillis());
		}
				
		String xml = "<segments>";
		for(String sequenceId: movieIds) {
			xml += String.format("<segment id=\"%s\"/>", sequenceId);
		}
		xml += "</segments>";
		
		Client c = Client.create();
		WebResource res = c.resource(BASE_URL).path("segment").path("createall");
		Form form = new Form();
		form.add("xml", xml);
		String response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.APPLICATION_XML_TYPE).post(String.class, form);

		Assert.assertNotNull(response);

		dbenv = new DbEnv();
		dbenv.setup(databasePathFile, true, true);

		DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());
		
		for(String sequenceId: movieIds) {		
			Assert.assertTrue(da.movieFragmentById.contains(sequenceId));
		}
		
	}
	
	
	@Test
	public void testReset() {
		Client c = Client.create();
		WebResource res = c.resource(BASE_URL);
		String response = res.path("engine").path("reset").accept(MediaType.TEXT_PLAIN).post(String.class);
		
		Assert.assertEquals(response, "ok");
		
		dbenv = new DbEnv();
		dbenv.setup(databasePathFile, true, true);

		DataAccessor da = new DataAccessor(this.dbenv.getEntityStore());

		Assert.assertEquals(0, da.movieFragmentById.count());
		Assert.assertEquals(0, da.tagById.count());
		Assert.assertEquals(0, da.tagByName.count());
		Assert.assertEquals(0, da.tagBySegment.count());		
		
	}
	
	@Test
	public void testTrain() {

		Client c = Client.create();
		WebResource res = c.resource(BASE_URL);
		String response = res.path("engine").path("reset").accept(MediaType.TEXT_PLAIN).post(String.class);
		
		String[] ids = new String[]{"ref1","ref2","ref3","ref4","ref5","ref6", "ref7"};

		String xmlSegment = "<segments>";
		for(String sequenceId: ids) {
			xmlSegment += String.format("<segment id=\"%s\"/>", sequenceId);
		}
		xmlSegment += "</segments>";

		c = Client.create();
		res = c.resource(BASE_URL).path("segment").path("createall");
		Form form = new Form();
		form.add("xml", xmlSegment);
		response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.APPLICATION_XML_TYPE).post(String.class, form);

		Assert.assertNotNull(response);

		
		ArrayList<String[]> tags = new ArrayList<String[]>();
		tags.add(new String[]{"crayon", "ref1"});
		tags.add(new String[]{"carte", "ref1"});
		tags.add(new String[]{"bateau", "ref1"});
		tags.add(new String[]{"voiture", "ref1"});
		tags.add(new String[]{"car", "ref1"});

		tags.add(new String[]{"enfant", "ref2"});
		tags.add(new String[]{"famille", "ref2"});
		tags.add(new String[]{"violon", "ref2"});
		tags.add(new String[]{"maison", "ref2"});
		tags.add(new String[]{"hopital", "ref2"});

		tags.add(new String[]{"enfant", "ref3"});
		tags.add(new String[]{"famille", "ref3"});
		tags.add(new String[]{"violon", "ref3"});
		tags.add(new String[]{"maison", "ref3"});
		tags.add(new String[]{"ordinateur", "ref3"});
		tags.add(new String[]{"fenetre", "ref3"});
		tags.add(new String[]{"voiture", "ref3"});
		tags.add(new String[]{"guitare", "ref3"});
		tags.add(new String[]{"carte", "ref3"});

		tags.add(new String[]{"enfant", "ref4"});
		tags.add(new String[]{"famille", "ref4"});
		tags.add(new String[]{"violon", "ref4"});
		tags.add(new String[]{"bateau", "ref4"});
		tags.add(new String[]{"ordinateur", "ref4"});
		tags.add(new String[]{"fenetre", "ref4"});
		tags.add(new String[]{"stylo", "ref4"});
		tags.add(new String[]{"perroquet", "ref4"});
		tags.add(new String[]{"crayon", "ref4"});
		tags.add(new String[]{"tele", "ref4"});
		tags.add(new String[]{"bateau", "ref4"});
		
		tags.add(new String[]{"ordinateur", "ref5"});
		tags.add(new String[]{"crayon", "ref5"});
		tags.add(new String[]{"fenetre", "ref5"});
		tags.add(new String[]{"hopital", "ref5"});
		tags.add(new String[]{"carte", "ref5"});
		tags.add(new String[]{"tele", "ref5"});
		tags.add(new String[]{"stylo", "ref5"});
		tags.add(new String[]{"perroquet", "ref5"});
		tags.add(new String[]{"bateau", "ref5"});
		tags.add(new String[]{"guitare", "ref5"});
		
		tags.add(new String[]{"maison", "ref6"});
		tags.add(new String[]{"perroquet", "ref6"});
		tags.add(new String[]{"stylo", "ref6"});
		tags.add(new String[]{"guitare", "ref6"});
		tags.add(new String[]{"hopital", "ref6"});
		tags.add(new String[]{"tele", "ref6"});
		tags.add(new String[]{"car", "ref6"});
		tags.add(new String[]{"voiture", "ref6"});
		tags.add(new String[]{"fenetre", "ref6"});
		
		tags.add(new String[]{"car", "ref7"});
		tags.add(new String[]{"voiture", "ref7"});

		String xmlTags = "<tags>";
		for(String[] tagdef: tags) {
			xmlTags += String.format("<tag name=\"%s\" segment=\"%s\"/>", (Object[])tagdef);
		}
		xmlTags += "</tags>";

		res = c.resource(BASE_URL).path("tag").path("add");
		form = new Form();
		form.add("xml", xmlTags);
		response = res.type(MediaType.APPLICATION_FORM_URLENCODED).accept(MediaType.APPLICATION_XML_TYPE).post(String.class, form);

		Assert.assertNotNull(response);

		//"engine/find/{segment}/{tag}/{percent}/{more}"
		//Neighbor neighbor = engine.findMore("ref1", "enfant", .05f, true);
		res = c.resource(BASE_URL).path("engine").path("find").path("ref1").path("enfant").path("0.05").path("true");
		response = res.accept(MediaType.APPLICATION_XML_TYPE).get(String.class);
		Assert.assertNotNull(response);
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    	InputSource source = new InputSource(new StringReader(response));
    	Document doc = null;
		try {
			doc = factory.newDocumentBuilder().parse(source);
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
		
		NodeList nodes = doc.getElementsByTagName("neighbor");
		
		Assert.assertEquals(1, nodes.getLength());
		
	}
	

}
