/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.TransformableItem;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FFVItem
extends TransformableItem {
    private static final long serialVersionUID = 1L;
    private static Hashtable<String, Float> featureSqrtVariances = new Hashtable();
    private static float[] featureSqrtVarianceValues;
    protected float[] featureVector = null;

    public float[] getFeatureVector() {
        if (this.featureVector == null) {
            this.computeFeatureVectorSlow();
        }
        return this.featureVector;
    }

    @Override
    public float distanceTo(TransformableItem m) {
        FFVItem ffvm = (FFVItem)m;
        float res = 0.0f;
        float[] v = this.getFeatureVector();
        float[] v2 = ffvm.getFeatureVector();
        int i = 0;
        while (i < v.length) {
            res += Math.abs(v[i] - v2[i]);
            ++i;
        }
        return res;
    }

    private void computeFeatureVectorSlow() {
        this.featureVector = new float[this.getFeatureNames().length];
        int cpt = 0;
        String[] stringArray = this.getFeatureNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String f = stringArray[n];
            this.featureVector[cpt] = this.getFeature(f) / featureSqrtVariances.get(f).floatValue();
            ++cpt;
            ++n;
        }
    }

    public static void computeMeansAndVariances(List<? extends TransformableItem> all) {
        if (all.size() == 0) {
            return;
        }
        String[] featureNames = all.get(0).getFeatureNames();
        featureSqrtVarianceValues = new float[featureNames.length];
        float[] res = new float[all.size()];
        int cpt = 0;
        String[] stringArray = featureNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String feature = stringArray[n];
            res = FFVItem.computeAll(all, feature);
            float val = (float)Math.sqrt(FFVItem.variance(res));
            featureSqrtVariances.put(feature, Float.valueOf(val));
            FFVItem.featureSqrtVarianceValues[cpt] = val;
            ++cpt;
            ++n;
        }
    }
}

