/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.Protocol;
import com.sleepycat.je.utilint.LoggerUtils;
import java.net.InetSocketAddress;
import java.util.Set;

public class MonitorEventManager {
    private long joinTime = 0L;
    private final RepNode repNode;

    public MonitorEventManager(RepNode repNode) {
        this.repNode = repNode;
    }

    public long getJoinTime() {
        return this.joinTime;
    }

    public void disableLeaveGroupEvent() {
        this.joinTime = 0L;
    }

    public void notifyGroupChange(String nodeName, GroupChangeEvent.GroupChangeType opType) throws DatabaseException {
        RepGroupImpl repGroup = this.repNode.getGroup();
        Protocol protocol = this.getProtocol(repGroup);
        protocol.getClass();
        Protocol.GroupChange changeEvent = new Protocol.GroupChange(protocol, repGroup, nodeName, opType);
        this.refreshMonitors(repGroup, changeEvent);
    }

    public void notifyJoinGroup() throws DatabaseException {
        if (this.joinTime > 0L) {
            return;
        }
        this.joinTime = System.currentTimeMillis();
        RepGroupImpl repGroup = this.repNode.getGroup();
        Protocol protocol = this.getProtocol(repGroup);
        protocol.getClass();
        Protocol.JoinGroup joinEvent = new Protocol.JoinGroup(protocol, this.repNode.getNodeName(), this.repNode.getMasterName(), this.joinTime);
        this.refreshMonitors(repGroup, joinEvent);
    }

    public void notifyLeaveGroup(LeaveGroupEvent.LeaveReason reason) throws DatabaseException {
        if (this.joinTime == 0L) {
            return;
        }
        RepGroupImpl repGroup = this.repNode.getGroup();
        Protocol protocol = this.getProtocol(repGroup);
        protocol.getClass();
        Protocol.LeaveGroup leaveEvent = new Protocol.LeaveGroup(protocol, this.repNode.getNodeName(), this.repNode.getMasterName(), reason, this.joinTime, System.currentTimeMillis());
        this.refreshMonitors(repGroup, leaveEvent);
    }

    private Protocol getProtocol(RepGroupImpl repGroup) {
        return new Protocol(repGroup.getName(), NameIdPair.NOCHECK, null);
    }

    private void refreshMonitors(RepGroupImpl repGroup, TextProtocol.RequestMessage requestMessage) {
        Set<InetSocketAddress> monitors = repGroup.getMonitorSockets();
        LoggerUtils.info(this.repNode.getLogger(), this.repNode.getRepImpl(), "Refreshed " + monitors.size() + " monitors.");
        Utils.broadcastMessage(monitors, "Monitor", requestMessage, this.repNode.getElections().getThreadPool());
    }
}

