package csl.tools.threads;

import java.util.List;
import java.util.Vector;

public class TestThreadPool {

	public void run(int threadCount, int itemCount) {

		ThreadPool<Integer, IntThread> p = new ThreadPool<Integer, IntThread>() {

			@Override
			public void show(IntThread th, Integer e) {

				System.out.println(th.name + " = " + e);
			}
		};
		for (int i = 0; i < threadCount; i++)
			p.addThread(new IntThread("T(" + i + ")", p));

		List<Integer> items = new Vector<Integer>();
		for (int i = 0; i < itemCount; i++)
			items.add(i);
		p.process(items);

		while (!p.isDone()) {
			try {
				Thread.sleep(10);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			}
		}
		System.out.println("DONE");
	}
}
