package csl.tools.stats;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import csl.tools.csv.CsvTools;
import csl.tools.files.FileTools;

public class KendallTau {

	public static List<List<Integer>> parallelSort(	final List<Integer> ranks1,
													final List<Integer> ranks2) {

		List<Integer> r1 = new ArrayList<Integer>(ranks1.size());
		List<Integer> r2 = new ArrayList<Integer>(ranks2.size());
		for (int i : ranks1) {
			r1.add(i);
			r2.add(-1);
		}
		Collections.sort(r1);
		for (int i = 0; i < ranks2.size(); i++) {
			int i1 = ranks1.get(i);
			int newIndex = r1.indexOf(i1);
			r2.set(newIndex, ranks2.get(i));
		}
		List<List<Integer>> list = new ArrayList<List<Integer>>();
		list.add(r1);
		list.add(r2);

		return list;
	}

	/**
	 * Computes and returns the coefficient P in Kendall-Tau's formula
	 * 
	 * @param ranks1
	 * @param ranks2
	 * @return
	 */
	public static int ktP(final List<Integer> ranks1, final List<Integer> ranks2) {

		int p = 0;
		List<Integer> list = parallelSort(ranks1, ranks2).get(1);
		for (int i = 0; i < list.size() - 1; i++) {
			int list_i = list.get(i);
			for (int j = i + 1; j < list.size(); j++) {
				if (list.get(j) > list_i)
					p++;
			}
		}
		return p;
	}

	public static double kt(final List<Integer> ranks1,
							final List<Integer> ranks2) {

		return (((double) (4 * ktP(ranks1, ranks2))) / (ranks1.size() * (ranks1
				.size() - 1))) - 1;
	}

	/**
	 * Computes and prints kt for every pair of list in the csv file
	 * 
	 * @param filename
	 * @throws IOException
	 */
	public static void ktForCsvFile(String filename) throws IOException {

		List<String> lines = FileTools.readLines(new File(filename));
		String header = lines.remove(0);
		String[] colHeaders = CsvTools.csvSplit(header);
		List<List<Integer>> cols = new ArrayList<List<Integer>>();
		for (int i = 0; i < colHeaders.length - 1; i++) {
			cols.add(new ArrayList<Integer>());
		}
		for (String line : lines) {
			String[] colValues = CsvTools.csvSplit(line);
			for (int i = 1; i < colValues.length; i++)
				cols.get(i - 1).add(Integer.parseInt(colValues[i]));
		}
		for (int i = 1; i < colHeaders.length - 1; i++)
			for (int j = i + 1; j < colHeaders.length; j++) {
				System.out.print("Kendall-tau for '" + colHeaders[i]
						+ "' and '" + colHeaders[j] + "' = ");
				System.out.println(kt(cols.get(i - 1), cols.get(j - 1)));
			}
	}

	public static void main(String[] args) throws IOException {

		ktForCsvFile("D:\\Users\\roy\\sony\\StreamMan\\Experimental Data\\"
				+ "Clean Results\\Ranks (for Spearman and Kendall).txt");
		ktForCsvFile("D:\\Users\\roy\\sony\\StreamMan\\Experimental Data\\"
				+ "Clean Results\\Test.txt");
	}
}
