package csl.tools.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StreamGobbler extends Thread {

	// used to pump out the stderr and stdout when using Runtime.exec
	InputStream		is;

	String			type;

	private boolean	quit;

	private boolean	silent;

	public StreamGobbler(InputStream is, String type, boolean silent) {

		this.silent = silent;
		this.quit = false;
		this.is = is;
		this.type = type;
	}

	@Override
	public void run() {

		InputStreamReader isr;
		BufferedReader br;
		String line = "";
		try {
			isr = new InputStreamReader(is);
			br = new BufferedReader(isr);
			while (!quit) {
				if ((line = br.readLine()) != null)
					if (!silent)
						System.out.println(type + " > " + line);
			}
			if (br != null)
				br.close();
			if (isr != null)
				isr.close();
		} catch (Exception ioe) {
			ioe.printStackTrace();
		}
	}

	/**
	 * Safely quits this thread
	 * 
	 */
	public void quit() {

		/*
		 * Completes gobbling
		 */

		InputStreamReader isr;
		BufferedReader br;
		String line = "";
		isr = new InputStreamReader(is);
		br = new BufferedReader(isr);
		try {
			while ((line = br.readLine()) != null) {
				if (!silent)
					System.out.println("*" + type + " > " + line);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		quit = true;
	}

	public static boolean exec(String[] cmd, boolean silent) {

		try {
			Runtime rt = Runtime.getRuntime();
			Process p = rt.exec(cmd);
			StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(),
					"err", silent);
			StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(),
					"out", silent);
			errorGobbler.start();
			outputGobbler.start();
			int exitValue = p.waitFor();
			errorGobbler.quit();
			outputGobbler.quit();
			return (exitValue == 0);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	public static boolean exec(String cmd, File workingDir, boolean silent) {

		try {
			Runtime rt = Runtime.getRuntime();
			Process p = rt.exec(cmd, null, workingDir);
			StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(),
					"err", silent);
			StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(),
					"out", silent);
			errorGobbler.start();
			outputGobbler.start();
			int exitValue = p.waitFor();
			errorGobbler.quit();
			outputGobbler.quit();
			return (exitValue == 0);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

}
