/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfig
implements Cloneable {
    public static final DatabaseConfig DEFAULT = new DatabaseConfig();
    private boolean allowCreate = false;
    private boolean exclusiveCreate = false;
    private boolean transactional = false;
    private boolean readOnly = false;
    private boolean duplicatesAllowed = false;
    private boolean deferredWrite = false;
    private boolean temporary = false;
    private boolean keyPrefixingEnabled = false;
    private boolean replicated = true;
    private int nodeMax;
    private int nodeMaxDupTree;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private boolean overrideBtreeComparator = false;
    private boolean overrideDupComparator = false;
    private boolean useExistingConfig = false;

    public DatabaseConfig setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
        return this;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public DatabaseConfig setExclusiveCreate(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
        return this;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public DatabaseConfig setSortedDuplicates(boolean duplicatesAllowed) {
        this.duplicatesAllowed = duplicatesAllowed;
        return this;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public boolean getKeyPrefixing() {
        return this.keyPrefixingEnabled;
    }

    public DatabaseConfig setKeyPrefixing(boolean keyPrefixingEnabled) {
        this.keyPrefixingEnabled = keyPrefixingEnabled;
        return this;
    }

    public DatabaseConfig setTransactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public DatabaseConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public DatabaseConfig setNodeMaxEntries(int nodeMaxEntries) {
        this.nodeMax = nodeMaxEntries;
        return this;
    }

    public DatabaseConfig setNodeMaxDupTreeEntries(int nodeMaxDupTreeEntries) {
        this.nodeMaxDupTree = nodeMaxDupTreeEntries;
        return this;
    }

    public int getNodeMaxEntries() {
        return this.nodeMax;
    }

    public int getNodeMaxDupTreeEntries() {
        return this.nodeMaxDupTree;
    }

    public DatabaseConfig setBtreeComparator(Comparator<byte[]> btreeComparator) {
        this.btreeComparator = this.validateComparator(btreeComparator, "Btree");
        this.btreeComparatorByClassName = false;
        return this;
    }

    public DatabaseConfig setBtreeComparator(Class<? extends Comparator<byte[]>> btreeComparatorClass) {
        this.btreeComparator = this.validateComparator(btreeComparatorClass, "Btree");
        this.btreeComparatorByClassName = true;
        return this;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public boolean getBtreeComparatorByClassName() {
        return this.btreeComparatorByClassName;
    }

    public DatabaseConfig setOverrideBtreeComparator(boolean override) {
        this.overrideBtreeComparator = override;
        return this;
    }

    public boolean getOverrideBtreeComparator() {
        return this.overrideBtreeComparator;
    }

    public void setDuplicateComparator(Comparator<byte[]> duplicateComparator) {
        this.duplicateComparator = this.validateComparator(duplicateComparator, "Duplicate");
        this.duplicateComparatorByClassName = false;
    }

    public DatabaseConfig setDuplicateComparator(Class<? extends Comparator<byte[]>> duplicateComparatorClass) {
        this.duplicateComparator = this.validateComparator(duplicateComparatorClass, "Duplicate");
        this.duplicateComparatorByClassName = true;
        return this;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public boolean getDuplicateComparatorByClassName() {
        return this.duplicateComparatorByClassName;
    }

    public DatabaseConfig setOverrideDuplicateComparator(boolean override) {
        this.overrideDupComparator = override;
        return this;
    }

    public boolean getOverrideDuplicateComparator() {
        return this.overrideDupComparator;
    }

    public DatabaseConfig setTemporary(boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public DatabaseConfig setDeferredWrite(boolean deferredWrite) {
        this.deferredWrite = deferredWrite;
        return this;
    }

    public boolean getDeferredWrite() {
        return this.deferredWrite;
    }

    void setBtreeComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.btreeComparator = comparator;
        this.btreeComparatorByClassName = byClassName;
    }

    void setDuplicateComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.duplicateComparator = comparator;
        this.duplicateComparatorByClassName = byClassName;
    }

    public DatabaseConfig setUseExistingConfig(boolean useExistingConfig) {
        this.useExistingConfig = useExistingConfig;
        return this;
    }

    public boolean getUseExistingConfig() {
        return this.useExistingConfig;
    }

    void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    boolean getReplicated() {
        return this.replicated;
    }

    public DatabaseConfig cloneConfig() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public DatabaseConfig clone() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void validate(DatabaseConfig config) throws DatabaseException {
        if (config == null) {
            config = DEFAULT;
        }
        boolean txnMatch = config.transactional == this.transactional;
        boolean roMatch = config.readOnly == this.readOnly;
        boolean sdMatch = config.duplicatesAllowed == this.duplicatesAllowed;
        boolean dwMatch = config.getDeferredWrite() == this.deferredWrite;
        boolean btCmpMatch = true;
        if (config.overrideBtreeComparator) {
            btCmpMatch = this.btreeComparator == null ? config.btreeComparator == null : (config.btreeComparatorByClassName != this.btreeComparatorByClassName ? false : (this.btreeComparatorByClassName ? this.btreeComparator.getClass() == config.btreeComparator.getClass() : Arrays.equals(DatabaseImpl.objectToBytes(this.btreeComparator, "Btree"), DatabaseImpl.objectToBytes(config.btreeComparator, "Btree"))));
        }
        boolean dtCmpMatch = true;
        if (config.overrideDupComparator) {
            dtCmpMatch = this.duplicateComparator == null ? config.duplicateComparator == null : (config.duplicateComparatorByClassName != this.duplicateComparatorByClassName ? false : (this.duplicateComparatorByClassName ? this.duplicateComparator.getClass() == config.duplicateComparator.getClass() : Arrays.equals(DatabaseImpl.objectToBytes(this.duplicateComparator, "Duplicate"), DatabaseImpl.objectToBytes(config.duplicateComparator, "Duplicate"))));
        }
        if (txnMatch && roMatch && sdMatch && dwMatch && btCmpMatch && dtCmpMatch) {
            return;
        }
        String message = this.genDatabaseConfigMismatchMessage(config, txnMatch, roMatch, sdMatch, dwMatch, btCmpMatch, dtCmpMatch);
        throw new IllegalArgumentException(message);
    }

    private String genDatabaseConfigMismatchMessage(DatabaseConfig config, boolean txnMatch, boolean roMatch, boolean sdMatch, boolean dwMatch, boolean btCmpMatch, boolean dtCmpMatch) {
        StringBuilder ret = new StringBuilder("The following DatabaseConfig parameters for the\ncached Database do not match the parameters for the\nrequested Database:\n");
        if (!txnMatch) {
            ret.append(" Transactional\n");
        }
        if (!roMatch) {
            ret.append(" Read-Only\n");
        }
        if (!sdMatch) {
            ret.append(" Sorted Duplicates\n");
        }
        if (!dwMatch) {
            ret.append(" Deferred Write");
        }
        if (!btCmpMatch) {
            ret.append(" Btree Comparator\n");
        }
        if (!dtCmpMatch) {
            ret.append(" Duplicate Comparator\n");
        }
        return ret.toString();
    }

    private Comparator<byte[]> validateComparator(Comparator<byte[]> comparator, String type) throws IllegalArgumentException {
        if (comparator == null) {
            return null;
        }
        try {
            return DatabaseImpl.instantiateComparator(comparator, type);
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid: " + e.getMessage() + "\nThe comparator object must be serializable.");
        }
    }

    private Comparator<byte[]> validateComparator(Class<? extends Comparator<byte[]>> comparatorClass, String type) throws IllegalArgumentException {
        if (comparatorClass == null) {
            return null;
        }
        if (!Comparator.class.isAssignableFrom(comparatorClass)) {
            throw new IllegalArgumentException(comparatorClass.getName() + " is is not valid as a " + type + " comparator because it does not " + " implement java.util.Comparator.");
        }
        try {
            return DatabaseImpl.instantiateComparator(comparatorClass, type);
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid: " + e.getMessage() + "\nPerhaps you have not implemented a zero-parameter " + "constructor for the comparator or the comparator class " + "cannot be found.");
        }
    }

    void validateForNewDb() throws DatabaseException {
        if (this.readOnly) {
            throw new IllegalArgumentException("DatabaseConfig.setReadOnly() must be set to false when creating a Database");
        }
        if (this.transactional && this.deferredWrite) {
            throw new IllegalArgumentException("deferredWrite mode is not supported for transactional databases");
        }
    }

    boolean persistentEquals(DatabaseConfig other) {
        if (this.duplicatesAllowed != other.duplicatesAllowed) {
            return false;
        }
        if (this.temporary != other.temporary) {
            return false;
        }
        if (this.replicated != other.replicated) {
            return false;
        }
        if (this.nodeMax != other.nodeMax) {
            return false;
        }
        if (this.nodeMaxDupTree != other.nodeMaxDupTree) {
            return false;
        }
        if (this.btreeComparator == null && other.btreeComparator != null || this.btreeComparator != null && other.btreeComparator == null) {
            return false;
        }
        if (this.btreeComparator != null && this.btreeComparator.getClass() != other.btreeComparator.getClass()) {
            return false;
        }
        if (this.duplicateComparator == null && other.duplicateComparator != null || this.duplicateComparator != null && other.duplicateComparator == null) {
            return false;
        }
        return this.duplicateComparator == null || this.duplicateComparator.getClass() == other.duplicateComparator.getClass();
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\nexclusiveCreate=" + this.exclusiveCreate + "\ntransactional=" + this.transactional + "\nreadOnly=" + this.readOnly + "\nduplicatesAllowed=" + this.duplicatesAllowed + "\ndeferredWrite=" + this.deferredWrite + "\ntemporary=" + this.temporary + "\nkeyPrefixingEnabled=" + this.keyPrefixingEnabled + "\n";
    }
}

