package csl.tools.parallel;

import java.util.List;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JProgressBar;

public abstract class ForP1<E> {

	private static final int	DEFAUL_NUM_PROC	= Runtime.getRuntime()
														.availableProcessors();

	protected static final int	NUM				= 10000;

	private List<E>				items;

	private int					numProc			= DEFAUL_NUM_PROC;

	private List<ForPThread>	threads			= new Vector<ForPThread>();

	private List<ForPThread>	terminated		= new Vector<ForPThread>();

	private int					counter			= 0;

	private final int			size;

	private boolean				done			= false;

	private JProgressBar		progressBar;

	private boolean				showProgress	= false;

	private boolean				showActivity	= false;

	private JFrame				progressFrame;

	private String				name;

	private ForPActivityPane	activityPane;

	private JFrame				activityFrame;

	public ForP1(String name, List<E> items) {

		this.name = name;
		this.items = items;
		this.size = items.size();
		if (showActivity)
			showActivity();
	}

	public ForP1(String name, List<E> items, int procCount) {

		this(name, items);
		this.numProc = procCount;
	}

	private void done() {

		done = true;
		hideProgress();
		hideActivity();
	}

	protected void done(E item, ForPThread subth) {

		System.out.println(subth + " did " + item);
		if (!showProgress)
			return;
		getProgressBar().setValue(getProgressBar().getValue() + 1);
	}

	protected void done(ForPThread th) {

		synchronized (terminated) {
			terminated.add(th);
			System.out.println(this + " n terminated = " + terminated.size());
			if (terminated.size() == threads.size())
				done();
		}
	}

	private JProgressBar getProgressBar() {

		if (progressBar == null) {
			progressBar = new JProgressBar();
			progressBar.setMinimum(0);
			progressBar.setMaximum(size);
			progressBar.setValue(0);
		}
		return progressBar;
	}

	private ForPActivityPane getActivityPane() {

		if (activityPane == null) {
			activityPane = new ForPActivityPane();
		}
		return activityPane;
	}

	private JFrame getProgressFrame() {

		if (progressFrame == null) {
			progressFrame = new JFrame("Progress...");
			progressFrame.setSize(750, 60);
			progressFrame.setAlwaysOnTop(true);
		}
		return progressFrame;
	}

	private JFrame getActivityFrame() {

		if (activityFrame == null) {
			activityFrame = new JFrame("Activity...");
			activityFrame.setSize(300, 400);
			activityFrame.setLocation(800, 200);
			activityFrame.setContentPane(getActivityPane());
			activityFrame.setAlwaysOnTop(true);
		}
		return activityFrame;
	}

	private void hideProgress() {

		if (!showProgress)
			return;
		showProgress = false;
		getProgressFrame().setVisible(false);
		progressFrame = null;
	}

	private void hideActivity() {

		if (!showActivity)
			return;
		showActivity = false;
		getActivityFrame().setVisible(false);
		activityFrame = null;
	}

	public boolean isDone() {

		return done;
	}

	protected synchronized E nextItem() {

		if (counter >= size)
			return null;
		return items.get(counter++);
	}

	public void process() {

		createThreads();
		runThreads();
	}

	public void process(boolean wait) {

		process();
		if (wait) {
			while (!done) {
				try {
					Thread.sleep(20);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
	}

	private ForPThread createThread(String name) {

		return new ForPThread(name, null) {

			private void done() {

				setDone();
				ForP1.this.done(this);
			}

			@Override
			public void run() {

				E item;
				while ((item = ForP1.this.nextItem()) != null) {
					ForP1.this.process(item, this);
					ForP1.this.done(item, this);
				}
				done();
			}
		};
	}

	private void createThreads() {

		for (int i = 0; i < numProc; i++) {
			ForPThread th;
			threads.add(th = createThread("th" + i));
			if (showActivity && th != null)
				th.setActivityPane(getActivityPane());
		}
	}

	private void runThreads() {

		for (ForPThread th : threads)
			th.start(showActivity);
	}

	abstract public void process(E item, ForPThread thread);

	public void showProgress() {

		showProgress = true;
		getProgressBar().setMinimum(0);
		getProgressBar().setMaximum(size);
		getProgressBar().setValue(0);
		getProgressFrame().getContentPane().add(getProgressBar());
		getProgressFrame().setVisible(true);
	}

	public void showActivity() {

		showActivity = true;
		getActivityFrame().setContentPane(getActivityPane());
		// getActivityFrame().pack();
		getActivityFrame().setVisible(true);
	}

	@Override
	public String toString() {

		return "Th: " + name;
	}

	public static void main(String[] args) {

		List<String> strings = new Vector<String>();
		strings.add("un");
		strings.add("deux");
		strings.add("trois");
		strings.add("quatre");
		strings.add("cinq");
		for (int i = 0; i < 12; i++)
			strings.addAll(strings);
		ForP1<String> lengthFP = new ForP1<String>("test", strings, 5) {

			@Override
			public void process(String item, ForPThread thread) {

				for (int i = 0; i < (int) (10000 * (1 + Math.random())); i++) {
					item = item.toLowerCase().toUpperCase();
				}
			}
		};
		lengthFP.process(true);
		System.out.println("done");
	}
}
