package csl.tools.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileTools {

	static Hashtable<String, File>			defaultDirs	= new Hashtable<String, File>();
	private static java.io.FileFilter		folderFF, audioFF, arffFF;
	private static java.io.FilenameFilter	audioFnF;

	/*
	 * File filters and filename filters
	 */
	public static java.io.FileFilter folderFF() {

		if (folderFF == null)
			folderFF = new java.io.FileFilter() {

				public boolean accept(File pathname) {

					return pathname.isDirectory();
				}
			};
		return folderFF;
	}

	public static java.io.FileFilter txtFF() {

		if (folderFF == null)
			folderFF = new java.io.FileFilter() {

				public boolean accept(File pathname) {

					return pathname.getName().toLowerCase().endsWith(".txt");
				}
			};
		return folderFF;
	}

	public static java.io.FileFilter audioFF() {

		if (audioFF == null)
			audioFF = new java.io.FileFilter() {

				public boolean accept(File pathname) {

					if (pathname.isHidden())
						return false;
					String nameLC = pathname.getName().toLowerCase();
					return nameLC.endsWith(".mp3") || nameLC.endsWith(".wav");
				}
			};
		return audioFF;
	}

	public static java.io.FileFilter arffFF() {

		if (arffFF == null)
			arffFF = new java.io.FileFilter() {

				public boolean accept(File pathname) {

					String nameLC = pathname.getName().toLowerCase();
					return nameLC.endsWith(".arff");
				}
			};
		return arffFF;
	}

	public static java.io.FilenameFilter audioFnF() {

		if (audioFnF == null)
			audioFnF = new java.io.FilenameFilter() {

				public boolean accept(File dir, String name) {

					String nameLC = name.toLowerCase();
					return nameLC.endsWith(".mp3") || nameLC.endsWith(".wma")
							|| nameLC.endsWith(".wav");
				}
			};
		return audioFnF;
	}

	/*
	 * File choosers
	 */
	public static File chooseFile(	String name,
									File dir,
									FileFilter ff,
									String title,
									String openButtonLabel) {

		if (dir == null)
			dir = defaultDirs.get(name);
		if (dir == null)
			dir = new File(".");
		JFileChooser fc = new JFileChooser(dir);
		if (ff != null)
			fc.setFileFilter(ff);
		if (openButtonLabel != null)
			fc.setApproveButtonText(openButtonLabel);
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
		if (title != null)
			fc.setDialogTitle(title);
		int returnVal = fc.showOpenDialog(null);
		if (returnVal != JFileChooser.APPROVE_OPTION)
			return null;
		File res = fc.getSelectedFile();
		defaultDirs.put(name, fc.getCurrentDirectory());
		return res;
	}

	public static File chooseDir(	String name,
									File dir,
									FileFilter ff,
									String title,
									String openButtonLabel) {

		if (dir == null)
			dir = name == null ? null : defaultDirs.get(name);
		if (dir == null)
			dir = new File(".");
		JFileChooser fc = new JFileChooser(dir);
		if (ff != null)
			fc.setFileFilter(ff);
		if (openButtonLabel != null)
			fc.setApproveButtonText(openButtonLabel);
		fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		if (title != null)
			fc.setDialogTitle(title);
		int returnVal = fc.showOpenDialog(null);
		if (returnVal != JFileChooser.APPROVE_OPTION)
			return null;
		File res = fc.getSelectedFile();
		if (name != null)
			defaultDirs.put(name, fc.getCurrentDirectory());
		return res;
	}

	public static File chooseFile(String name) {

		return chooseFile(name, null, null, null, null);
	}

	public static File chooseFile(String name, File root) {

		return chooseFile(name, root, null, null, null);
	}

	public static File chooseDir(String name) {

		return chooseDir(name, null, null, null, null);
	}

	public static File chooseDir(String name, File root) {

		return chooseDir(name, root, null, null, null);
	}

	public static File chooseFile(String name, final String extension) {

		return chooseFile(name, null, new FileFilter() {

			@Override
			public boolean accept(File arg0) {

				return arg0.getName().toLowerCase().endsWith(extension)
						|| arg0.isDirectory();
			}

			@Override
			public String getDescription() {

				// TODO Auto-generated method stub
				return null;
			}
		}, null, null);
	}

	public static File chooseDir(String name, final String extension) {

		return chooseFile(name, null, new FileFilter() {

			@Override
			public boolean accept(File arg0) {

				return arg0.getName().toLowerCase().endsWith(extension)
						|| arg0.isDirectory();
			}

			@Override
			public String getDescription() {

				// TODO Auto-generated method stub
				return null;
			}
		}, null, null);
	}

	public static List<File> chooseFiles(	String name,
											File dir,
											FileFilter ff,
											String title,
											String openButtonLabel) {

		if (dir == null)
			dir = defaultDirs.get(name);
		if (dir == null)
			dir = new File(".");
		JFileChooser fc = new JFileChooser(dir);
		fc.setMultiSelectionEnabled(true);
		if (ff != null)
			fc.setFileFilter(ff);
		if (openButtonLabel != null)
			fc.setApproveButtonText(openButtonLabel);
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
		if (title != null)
			fc.setDialogTitle(title);
		int returnVal = fc.showOpenDialog(null);
		if (returnVal != JFileChooser.APPROVE_OPTION)
			return null;
		defaultDirs.put(name, fc.getCurrentDirectory());
		return Arrays.asList(fc.getSelectedFiles());
	}

	public static List<File> chooseFiles(String name) {

		return chooseFiles(name, null, null, null, null);
	}

	public static List<File> chooseFiles(String name, final String extension) {

		return chooseFiles(name, null, new FileFilter() {

			@Override
			public boolean accept(File arg0) {

				return arg0.getName().toLowerCase().endsWith(extension)
						|| arg0.isDirectory();
			}

			@Override
			public String getDescription() {

				// TODO Auto-generated method stub
				return null;
			}
		}, null, null);
	}

	public static boolean containsFileNamed(File dir, String filename) {

		if (dir == null || !dir.isDirectory())
			return false;
		for (File f : dir.listFiles())
			if (f.getName().equalsIgnoreCase(filename))
				return true;
		return false;
	}

	/*
	 * Filename management
	 */
	/**
	 * Return "f" name without extension
	 */
	public static String shortName(File f) {

		return nameWithoutExtension(f);
	}

	/**
	 * Return "f" name without extension
	 */
	public static String nameWithoutExtension(File f) {

		String s = f.getName();
		int i = s.lastIndexOf('.');
		if (i < 0)
			return s;
		return s.substring(0, i);
	}

	/**
	 * Return the extension of "f"
	 */
	public static String extension(File f) {

		String s = f.getName();
		int i = s.lastIndexOf('.');
		if (i < 0)
			return "";
		return s.substring(i + 1, s.length() - 1);
	}

	/**
	 * Replaces the extension in "f" name by "ext"
	 */
	public static File withExtension(File f, String ext) {

		int extIndex = f.getName().lastIndexOf(".");
		if (extIndex < 0)
			return new File(f.getPath() + "." + ext);
		return new File(f.getParentFile(), f.getName().substring(0, extIndex)
				+ "." + ext);
	}

	/*
	 * Text file management
	 */
	public static String textContents(File textFile) throws IOException {

		StringBuffer buf = new StringBuffer();
		BufferedReader r = new BufferedReader(new FileReader(textFile));
		while (r.ready())
			buf.append(r.readLine()).append("\n");
		r.close();
		return buf.toString();
	}

	public static List<String> readLines(String string) throws IOException {

		List<String> lines = new ArrayList<String>();
		BufferedReader br = new BufferedReader(new FileReader(string));
		while (br.ready())
			lines.add(br.readLine());
		br.close();
		return lines;
	}

	public static void append(File f, Object obj) throws IOException {

		PrintWriter pw = new PrintWriter(new FileWriter(f, true));
		pw.append(obj.toString());
		pw.println();
		pw.close();
	}

	public static void write(File f, Object obj) throws IOException {

		PrintWriter pw = new PrintWriter(new FileWriter(f, true));
		pw.write(obj.toString());
		pw.close();
	}

	public static PrintWriter printWriterOn(File f, boolean append) {

		try {
			return new PrintWriter(new FileOutputStream(f, append));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static void append(PrintWriter pw, StringBuffer contents) {

		pw.print(contents.toString());
		pw.flush();
	}

	public static void closeTextFile(PrintWriter pw) {

		if (pw == null)
			return;
		pw.close();
	}

	/*
	 * Folder exploration
	 */
	public static List<File> listFilesRec(File root, java.io.FileFilter ff) {

		return listFiles(root, ff, true);
	}

	public static List<File> listFilesRec(File root, java.io.FilenameFilter ff) {

		return listFiles(root, ff, true);
	}

	public static List<File> recListFiles(File root, java.io.FileFilter ff) {

		return listFiles(root, ff, true);
	}

	public static List<File> recListFiles(File root, java.io.FilenameFilter ff) {

		return listFiles(root, ff, true);
	}

	public static List<File> listFiles(	File root,
										java.io.FileFilter ff,
										boolean rec) {

		List<File> files = new ArrayList<File>();
		for (File f : root.listFiles(ff))
			files.add(f);
		if (rec)
			for (File f : listFolders(root))
				files.addAll(listFiles(f, ff, rec));
		return files;
	}

	public static List<File> listFiles(	File root,
										java.io.FilenameFilter ff,
										boolean rec) {

		List<File> files = new Vector<File>(50000);
		for (File f : root.listFiles(ff))
			files.add(f);
		if (rec)
			for (File f : listFolders(root))
				files.addAll(listFiles(f, ff, rec));
		return files;
	}

	public static List<File> listFolders(File root) {

		File[] flist = root.listFiles(folderFF());
		List<File> list = new Vector<File>(flist.length);
		for (File f : flist)
			list.add(f);
		return list;
	}

	public static void sortTextFile(String input, String output)
			throws IOException {

		sortTextFile(new File(input), new File(output));
	}

	public static void sortTextFile(File input, File output) throws IOException {

		List<String> strings = FileTools.readLines(input.getPath());
		Collections.sort(strings);
		for (String s : strings) {
			FileTools.write(output, s + "\n");
		}
	}

	public static PrintWriter printWriterOn(File logFile) {

		return printWriterOn(logFile, false);
	}

	public static PrintWriter printWriterOn(String logFile) {

		return printWriterOn(logFile, false);
	}

	public static PrintWriter printWriterOn(String logFile, boolean append) {

		return printWriterOn(new File(logFile), append);
	}

	/**
	 * e.g. relativeDir("c:\src\", "c:\src\files\media\toto.wav" returns
	 * "files\media\toto.wav"
	 * 
	 * @param audioFile
	 * @param src
	 * @return
	 */
	public static String getRelativeDir(String main, String sub) {

		main = main.toLowerCase();
		sub = sub.toLowerCase();
		if (!sub.startsWith(main)) {
			return null;
		}
		sub = new File(sub).getParent();
		return sub.substring(main.length());
	}

	public static String getRelativeDir(File main, File sub) {

		return getRelativeDir(main.getPath(), sub.getPath());
	}

	public static void copy(File src, File dst) throws IOException {

		if (src.getAbsoluteFile().equals(dst.getAbsoluteFile()))
			return;
		InputStream in = new FileInputStream(src);
		OutputStream out = new FileOutputStream(dst);
		byte[] buf = new byte[16384];
		int len;
		while ((len = in.read(buf)) > 0)
			out.write(buf, 0, len);
		in.close();
		out.close();
	}

	public static File chooseDir(File defaultDir) {

		if (defaultDir == null)
			defaultDir = new File(".");
		JFileChooser fc = new JFileChooser(defaultDir);
		fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		fc.setSelectedFile(defaultDir);
		fc.setCurrentDirectory(defaultDir);
		fc.setDialogTitle("Choose folder...");
		int returnVal = fc.showOpenDialog(null);
		if (returnVal != JFileChooser.APPROVE_OPTION)
			return null;
		return fc.getSelectedFile();
	}

	public static File loadFile(File defaultDir) {

		if (defaultDir == null)
			defaultDir = new File(".");
		JFileChooser fc = new JFileChooser(defaultDir);
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
		fc.setSelectedFile(defaultDir);
		fc.setCurrentDirectory(defaultDir);
		fc.setDialogTitle("Choose file...");
		int returnVal = fc.showOpenDialog(null);
		if (returnVal != JFileChooser.APPROVE_OPTION)
			return null;
		return fc.getSelectedFile();
	}

	public static List<File> loadFiles(File defaultDir) {

		if (defaultDir == null)
			defaultDir = new File(".");
		JFileChooser fc = new JFileChooser(defaultDir);
		fc.setMultiSelectionEnabled(true);
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
		fc.setSelectedFile(defaultDir);
		fc.setCurrentDirectory(defaultDir);
		fc.setDialogTitle("Choose file...");
		int returnVal = fc.showOpenDialog(null);
		if (returnVal != JFileChooser.APPROVE_OPTION)
			return null;
		File[] res = fc.getSelectedFiles();
		List<File> res2 = new Vector<File>();
		for (File f : res)
			res2.add(f);
		return res2;
	}

	public static Object loadObject(File f) throws FileNotFoundException,
			IOException, ClassNotFoundException {

		ObjectInputStream s = new ObjectInputStream(new FileInputStream(f));
		Object loaded = s.readObject();
		s.close();
		return loaded;
	}

	public static List<String> readLines(File txtFile, int from, int to)
			throws IOException {

		List<String> lines = new Vector<String>(to - from + 1);
		BufferedReader br = new BufferedReader(new FileReader(txtFile));
		int i = 0;
		while (br.ready() && i <= to) {
			final String line = br.readLine();
			if (i >= from && i <= to)
				lines.add(line);
			i++;
		}
		br.close();
		return lines;
	}

	public static List<String> readLines(File txtFile) throws IOException {

		return readLines(txtFile.getPath());
	}
}
