package csl.tools.files;

import java.io.File;
import java.util.List;

public class DirComparison {

	final File	dir1, dir2;
	final List<File>	newerFiles, olderFiles, sameDateFiles;

	public DirComparison(File d1,
			File d2,
			List<File> newerFiles,
			List<File> olderFiles,
			List<File> sameDateFiles) {

		super();
		this.newerFiles = newerFiles;
		this.olderFiles = olderFiles;
		this.sameDateFiles = sameDateFiles;
		this.dir1 = d1;
		this.dir2 = d2;
	}

	@Override
	public String toString() {

		StringBuffer sb = new StringBuffer();
		sb.append("Newer in ").append(dir1).append("\n---\n");
		for (File f : newerFiles)
			sb.append("\t").append(f.getName()).append("\n");
		sb.append("\n");
		sb.append("Older in ").append(dir1).append("\n---\n");
		for (File f : olderFiles)
			sb.append("\t").append(f.getName()).append("\n");
		sb.append("\n");
		sb.append("Identical ").append("\n---\n");
		for (File f : sameDateFiles)
			sb.append("\t").append(f.getName()).append("\n");
		sb.append("\n");
		return sb.toString();
	}
}
