/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.UpdateableClusterer;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SerializationHelper;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClusterEvaluation
implements Serializable {
    static final long serialVersionUID = -830188327319128005L;
    private Clusterer m_Clusterer;
    private StringBuffer m_clusteringResults;
    private int m_numClusters;
    private double[] m_clusterAssignments;
    private double m_logL;
    private int[] m_classToCluster = null;

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public String clusterResultsToString() {
        return this.m_clusteringResults.toString();
    }

    public int getNumClusters() {
        return this.m_numClusters;
    }

    public double[] getClusterAssignments() {
        return this.m_clusterAssignments;
    }

    public int[] getClassesToClusters() {
        return this.m_classToCluster;
    }

    public double getLogLikelihood() {
        return this.m_logL;
    }

    public ClusterEvaluation() {
        this.setClusterer(new SimpleKMeans());
        this.m_clusteringResults = new StringBuffer();
        this.m_clusterAssignments = null;
    }

    public void evaluateClusterer(Instances instances) throws Exception {
        this.evaluateClusterer(instances, "");
    }

    public void evaluateClusterer(Instances instances, String string) throws Exception {
        int n;
        int n2 = 0;
        double d = 0.0;
        this.m_numClusters = n = this.m_Clusterer.numberOfClusters();
        double[] dArray = new double[n];
        Instances instances2 = null;
        boolean bl = instances.classIndex() >= 0;
        int n3 = 0;
        Vector<Double> vector = new Vector<Double>();
        Remove remove = null;
        ConverterUtils.DataSource dataSource = null;
        if (string == null) {
            string = "";
        }
        dataSource = string.length() != 0 ? new ConverterUtils.DataSource(string) : new ConverterUtils.DataSource(instances);
        instances2 = dataSource.getStructure(instances.classIndex());
        if (bl) {
            if (instances2.classAttribute().isNumeric()) {
                throw new Exception("ClusterEvaluation: Class must be nominal!");
            }
            remove = new Remove();
            remove.setAttributeIndices("" + (instances2.classIndex() + 1));
            remove.setInvertSelection(false);
            ((Filter)remove).setInputFormat(instances2);
        }
        n2 = 0;
        while (dataSource.hasMoreElements(instances2)) {
            Instance instance = dataSource.nextElement(instances2);
            if (remove != null) {
                ((Filter)remove).input(instance);
                remove.batchFinished();
                instance = remove.output();
            }
            int n4 = -1;
            try {
                if (this.m_Clusterer instanceof DensityBasedClusterer) {
                    d += ((DensityBasedClusterer)this.m_Clusterer).logDensityForInstance(instance);
                    n4 = this.m_Clusterer.clusterInstance(instance);
                    vector.add(Double.valueOf(n4));
                } else {
                    n4 = this.m_Clusterer.clusterInstance(instance);
                    vector.add(Double.valueOf(n4));
                }
            }
            catch (Exception exception) {
                vector.add(0.0);
                ++n3;
            }
            if (n4 == -1) continue;
            int n5 = n4;
            dArray[n5] = dArray[n5] + 1.0;
        }
        double d2 = Utils.sum(dArray);
        this.m_logL = d /= d2;
        this.m_clusterAssignments = new double[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.m_clusterAssignments[n2] = (Double)vector.get(n2);
        }
        int n6 = (int)(Math.log(vector.size()) / Math.log(10.0) + 1.0);
        this.m_clusteringResults.append(this.m_Clusterer.toString());
        this.m_clusteringResults.append("Clustered Instances\n\n");
        int n7 = (int)(Math.log(n) / Math.log(10.0) + 1.0);
        for (n2 = 0; n2 < n; ++n2) {
            if (!(dArray[n2] > 0.0)) continue;
            this.m_clusteringResults.append(Utils.doubleToString(n2, n7, 0) + "      " + Utils.doubleToString(dArray[n2], n6, 0) + " (" + Utils.doubleToString(dArray[n2] / d2 * 100.0, 3, 0) + "%)\n");
        }
        if (n3 > 0) {
            this.m_clusteringResults.append("\nUnclustered instances : " + n3);
        }
        if (this.m_Clusterer instanceof DensityBasedClusterer) {
            this.m_clusteringResults.append("\n\nLog likelihood: " + Utils.doubleToString(d, 1, 5) + "\n");
        }
        if (bl) {
            this.evaluateClustersWithRespectToClass(instances, string);
        }
    }

    private void evaluateClustersWithRespectToClass(Instances instances, String string) throws Exception {
        int n = instances.classAttribute().numValues();
        int[][] nArray = new int[this.m_numClusters][n];
        int[] nArray2 = new int[this.m_numClusters];
        double[] dArray = new double[this.m_numClusters + 1];
        double[] dArray2 = new double[this.m_numClusters + 1];
        ConverterUtils.DataSource dataSource = null;
        Instances instances2 = null;
        Instance instance = null;
        if (string == null) {
            string = "";
        }
        dataSource = string.length() != 0 ? new ConverterUtils.DataSource(string) : new ConverterUtils.DataSource(instances);
        instances2 = dataSource.getStructure(instances.classIndex());
        int n2 = 0;
        while (dataSource.hasMoreElements(instances2)) {
            instance = dataSource.nextElement(instances2);
            int[] nArray3 = nArray[(int)this.m_clusterAssignments[n2]];
            int n3 = (int)instance.classValue();
            nArray3[n3] = nArray3[n3] + 1;
            int n4 = (int)this.m_clusterAssignments[n2];
            nArray2[n4] = nArray2[n4] + 1;
            ++n2;
        }
        int n5 = n2;
        dArray[this.m_numClusters] = Double.MAX_VALUE;
        this.mapClasses(0, nArray, nArray2, dArray2, dArray, 0);
        this.m_clusteringResults.append("\n\nClass attribute: " + instances.classAttribute().name() + "\n");
        this.m_clusteringResults.append("Classes to Clusters:\n");
        String string2 = this.toMatrixString(nArray, nArray2, new Instances(instances, 0));
        this.m_clusteringResults.append(string2).append("\n");
        int n6 = 1 + (int)(Math.log(this.m_numClusters) / Math.log(10.0));
        for (n2 = 0; n2 < this.m_numClusters; ++n2) {
            if (nArray2[n2] <= 0) continue;
            this.m_clusteringResults.append("Cluster " + Utils.doubleToString(n2, n6, 0));
            this.m_clusteringResults.append(" <-- ");
            if (dArray[n2] < 0.0) {
                this.m_clusteringResults.append("No class\n");
                continue;
            }
            this.m_clusteringResults.append(instances.classAttribute().value((int)dArray[n2])).append("\n");
        }
        this.m_clusteringResults.append("\nIncorrectly clustered instances :\t" + dArray[this.m_numClusters] + "\t" + Utils.doubleToString(dArray[this.m_numClusters] / (double)n5 * 100.0, 8, 4) + " %\n");
        this.m_classToCluster = new int[this.m_numClusters];
        for (n2 = 0; n2 < this.m_numClusters; ++n2) {
            this.m_classToCluster[n2] = (int)dArray[n2];
        }
    }

    private String toMatrixString(int[][] nArray, int[] nArray2, Instances instances) throws Exception {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (n2 = 0; n2 < this.m_numClusters; ++n2) {
            for (n = 0; n < nArray[n2].length; ++n) {
                if (nArray[n2][n] <= n3) continue;
                n3 = nArray[n2][n];
            }
        }
        n2 = 1 + Math.max((int)(Math.log(n3) / Math.log(10.0)), (int)(Math.log(this.m_numClusters) / Math.log(10.0)));
        stringBuffer.append("\n");
        for (n = 0; n < this.m_numClusters; ++n) {
            if (nArray2[n] <= 0) continue;
            stringBuffer.append(" ").append(Utils.doubleToString(n, n2, 0));
        }
        stringBuffer.append("  <-- assigned to cluster\n");
        for (n = 0; n < nArray[0].length; ++n) {
            for (int i = 0; i < this.m_numClusters; ++i) {
                if (nArray2[i] <= 0) continue;
                stringBuffer.append(" ").append(Utils.doubleToString(nArray[i][n], n2, 0));
            }
            stringBuffer.append(" | ").append(instances.classAttribute().value(n)).append("\n");
        }
        return stringBuffer.toString();
    }

    private void mapClasses(int n, int[][] nArray, int[] nArray2, double[] dArray, double[] dArray2, int n2) {
        block6: {
            block5: {
                if (n != this.m_numClusters) break block5;
                if (!((double)n2 < dArray2[this.m_numClusters])) break block6;
                dArray2[this.m_numClusters] = n2;
                for (int i = 0; i < this.m_numClusters; ++i) {
                    dArray2[i] = dArray[i];
                }
                break block6;
            }
            if (nArray2[n] == 0) {
                dArray[n] = -1.0;
                this.mapClasses(n + 1, nArray, nArray2, dArray, dArray2, n2);
            } else {
                dArray[n] = -1.0;
                this.mapClasses(n + 1, nArray, nArray2, dArray, dArray2, n2 + nArray2[n]);
                for (int i = 0; i < nArray[0].length; ++i) {
                    if (nArray[n][i] <= 0) continue;
                    boolean bl = true;
                    for (int j = 0; j < n; ++j) {
                        if ((int)dArray[j] != i) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    dArray[n] = i;
                    this.mapClasses(n + 1, nArray, nArray2, dArray, dArray2, n2 + (nArray2[n] - nArray[n][i]));
                }
            }
        }
    }

    public static String evaluateClusterer(Clusterer clusterer, String[] stringArray) throws Exception {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        int n = 1;
        int n2 = 10;
        boolean bl = false;
        Instances instances = null;
        String[] stringArray2 = null;
        boolean bl2 = false;
        Range range = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = -1;
        boolean bl3 = clusterer instanceof UpdateableClusterer;
        ConverterUtils.DataSource dataSource = null;
        try {
            String string6;
            String string7;
            String string8;
            if (Utils.getFlag('h', stringArray)) {
                throw new Exception("Help requested.");
            }
            string5 = Utils.getOption('l', stringArray);
            string4 = Utils.getOption('d', stringArray);
            string3 = Utils.getOption('t', stringArray);
            string2 = Utils.getOption('T', stringArray);
            string = Utils.getOption('g', stringArray);
            try {
                string8 = Utils.getOption('p', stringArray);
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage() + "\nNOTE: the -p option has changed. " + "It now expects a parameter specifying a range of attributes " + "to list with the predictions. Use '-p 0' for none.");
            }
            if (string8.length() != 0) {
                bl2 = true;
                if (!string8.equals("0")) {
                    range = new Range(string8);
                }
            }
            if (string3.length() == 0) {
                if (string5.length() == 0) {
                    throw new Exception("No training file and no object input file given.");
                }
                if (string2.length() == 0) {
                    throw new Exception("No training file and no test file given.");
                }
            } else if (string5.length() != 0 && !bl2) {
                throw new Exception("Can't use both train and model file unless -p specified.");
            }
            if ((string7 = Utils.getOption('s', stringArray)).length() != 0) {
                n = Integer.parseInt(string7);
            }
            if ((string6 = Utils.getOption('x', stringArray)).length() != 0) {
                n2 = Integer.parseInt(string6);
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new Exception('\n' + exception.getMessage() + ClusterEvaluation.makeOptionString(clusterer));
        }
        try {
            if (string3.length() != 0) {
                dataSource = new ConverterUtils.DataSource(string3);
                instances = dataSource.getStructure();
                object = Utils.getOption('c', stringArray);
                if (((String)object).length() != 0) {
                    n3 = ((String)object).compareTo("last") == 0 ? instances.numAttributes() : (((String)object).compareTo("first") == 0 ? 1 : Integer.parseInt((String)object));
                    if (n3 != -1) {
                        if (bl || string2.length() != 0) {
                            throw new Exception("Can only do class based evaluation on the training data");
                        }
                        if (string5.length() != 0) {
                            throw new Exception("Can't load a clusterer and do class based evaluation");
                        }
                        if (string4.length() != 0) {
                            throw new Exception("Can't do class based evaluation and save clusterer");
                        }
                    }
                } else if (instances.classIndex() != -1) {
                    n3 = instances.classIndex() + 1;
                    System.err.println("Note: using class attribute from dataset, i.e., attribute #" + n3);
                }
                if (n3 != -1) {
                    if (n3 < 1 || n3 > instances.numAttributes()) {
                        throw new Exception("Class is out of range!");
                    }
                    if (!instances.attribute(n3 - 1).isNominal()) {
                        throw new Exception("Class must be nominal!");
                    }
                    instances.setClassIndex(n3 - 1);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("ClusterEvaluation: " + exception.getMessage() + '.');
        }
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        if (string5.length() != 0) {
            Utils.checkForRemainingOptions(stringArray);
        }
        if (clusterer instanceof OptionHandler) {
            ((OptionHandler)((Object)clusterer)).setOptions(stringArray);
        }
        Utils.checkForRemainingOptions(stringArray);
        if (string5.length() != 0) {
            clusterer = (Clusterer)SerializationHelper.read(string5);
        } else if (n3 == -1) {
            if (bl3) {
                clusterer.buildClusterer(dataSource.getStructure());
                while (dataSource.hasMoreElements(instances)) {
                    Instance instance = dataSource.nextElement(instances);
                    ((UpdateableClusterer)((Object)clusterer)).updateClusterer(instance);
                }
                ((UpdateableClusterer)((Object)clusterer)).updateFinished();
            } else {
                clusterer.buildClusterer(dataSource.getDataSet());
            }
        } else {
            Serializable serializable;
            object = new Remove();
            ((Remove)object).setAttributeIndices("" + n3);
            ((Remove)object).setInvertSelection(false);
            ((Remove)object).setInputFormat(instances);
            if (bl3) {
                serializable = Filter.useFilter(instances, (Filter)object);
                clusterer.buildClusterer((Instances)serializable);
                while (dataSource.hasMoreElements(instances)) {
                    Instance instance = dataSource.nextElement(instances);
                    ((Remove)object).input(instance);
                    ((Filter)object).batchFinished();
                    Instance instance2 = ((Filter)object).output();
                    ((UpdateableClusterer)((Object)clusterer)).updateClusterer(instance2);
                }
                ((UpdateableClusterer)((Object)clusterer)).updateFinished();
            } else {
                serializable = Filter.useFilter(dataSource.getDataSet(), (Filter)object);
                clusterer.buildClusterer((Instances)serializable);
            }
            serializable = new ClusterEvaluation();
            ((ClusterEvaluation)serializable).setClusterer(clusterer);
            ((ClusterEvaluation)serializable).evaluateClusterer(instances, string3);
            return "\n\n=== Clustering stats for training data ===\n\n" + ((ClusterEvaluation)serializable).clusterResultsToString();
        }
        if (bl2) {
            return ClusterEvaluation.printClusterings(clusterer, string3, string2, range);
        }
        stringBuffer.append(clusterer.toString());
        stringBuffer.append("\n\n=== Clustering stats for training data ===\n\n" + ClusterEvaluation.printClusterStats(clusterer, string3));
        if (string2.length() != 0) {
            stringBuffer.append("\n\n=== Clustering stats for testing data ===\n\n" + ClusterEvaluation.printClusterStats(clusterer, string2));
        }
        if (clusterer instanceof DensityBasedClusterer && bl && string2.length() == 0 && string5.length() == 0) {
            Random random = new Random(n);
            random.setSeed(n);
            instances = dataSource.getDataSet();
            instances.randomize(random);
            stringBuffer.append(ClusterEvaluation.crossValidateModel(clusterer.getClass().getName(), instances, n2, stringArray2, random));
        }
        if (string4.length() != 0) {
            SerializationHelper.write(string4, (Object)clusterer);
        }
        if (clusterer instanceof Drawable && string.length() != 0) {
            object = new BufferedWriter(new FileWriter(string));
            ((Writer)object).write(((Drawable)((Object)clusterer)).graph());
            ((BufferedWriter)object).newLine();
            ((BufferedWriter)object).flush();
            ((BufferedWriter)object).close();
        }
        return stringBuffer.toString();
    }

    public static double crossValidateModel(DensityBasedClusterer densityBasedClusterer, Instances instances, int n, Random random) throws Exception {
        double d = 0.0;
        instances = new Instances(instances);
        instances.randomize(random);
        for (int i = 0; i < n; ++i) {
            Instances instances2 = instances.trainCV(n, i, random);
            densityBasedClusterer.buildClusterer(instances2);
            Instances instances3 = instances.testCV(n, i);
            for (int j = 0; j < instances3.numInstances(); ++j) {
                try {
                    d += densityBasedClusterer.logDensityForInstance(instances3.instance(j));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return d / (double)instances.numInstances();
    }

    public static String crossValidateModel(String string, Instances instances, int n, String[] stringArray, Random random) throws Exception {
        Clusterer clusterer = null;
        String[] stringArray2 = null;
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
        }
        instances = new Instances(instances);
        try {
            clusterer = (Clusterer)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("Can't find class with name " + string + '.');
        }
        if (!(clusterer instanceof DensityBasedClusterer)) {
            throw new Exception(string + " must be a distrinbution " + "clusterer.");
        }
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        if (clusterer instanceof OptionHandler) {
            try {
                ((OptionHandler)((Object)clusterer)).setOptions(stringArray2);
                Utils.checkForRemainingOptions(stringArray2);
            }
            catch (Exception exception) {
                throw new Exception("Can't parse given options in cross-validation!");
            }
        }
        d = ClusterEvaluation.crossValidateModel((DensityBasedClusterer)clusterer, instances, n, random);
        stringBuffer.append("\n" + n + " fold CV Log Likelihood: " + Utils.doubleToString(d, 6, 4) + "\n");
        return stringBuffer.toString();
    }

    private static String printClusterStats(Clusterer clusterer, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        double d = 0.0;
        int n2 = clusterer.numberOfClusters();
        double[] dArray = new double[n2];
        int n3 = 0;
        if (string.length() != 0) {
            ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(string);
            Instances instances = dataSource.getStructure();
            while (dataSource.hasMoreElements(instances)) {
                Instance instance = dataSource.nextElement(instances);
                try {
                    int n4 = clusterer.clusterInstance(instance);
                    if (clusterer instanceof DensityBasedClusterer) {
                        d += ((DensityBasedClusterer)clusterer).logDensityForInstance(instance);
                    }
                    int n5 = n4;
                    dArray[n5] = dArray[n5] + 1.0;
                }
                catch (Exception exception) {
                    ++n3;
                }
                ++n;
            }
            int n6 = (int)(Math.log(n2) / Math.log(10.0) + 1.0);
            int n7 = (int)(Math.log(n) / Math.log(10.0) + 1.0);
            double d2 = Utils.sum(dArray);
            d /= d2;
            stringBuffer.append("Clustered Instances\n");
            for (n = 0; n < n2; ++n) {
                if (!(dArray[n] > 0.0)) continue;
                stringBuffer.append(Utils.doubleToString(n, n6, 0) + "      " + Utils.doubleToString(dArray[n], n7, 0) + " (" + Utils.doubleToString(dArray[n] / d2 * 100.0, 3, 0) + "%)\n");
            }
            if (n3 > 0) {
                stringBuffer.append("\nUnclustered Instances : " + n3);
            }
            if (clusterer instanceof DensityBasedClusterer) {
                stringBuffer.append("\n\nLog likelihood: " + Utils.doubleToString(d, 1, 5) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String printClusterings(Clusterer clusterer, String string, String string2, Range range) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        ConverterUtils.DataSource dataSource = null;
        dataSource = string2.length() != 0 ? new ConverterUtils.DataSource(string2) : new ConverterUtils.DataSource(string);
        Instances instances = dataSource.getStructure();
        while (dataSource.hasMoreElements(instances)) {
            Instance instance = dataSource.nextElement(instances);
            try {
                int n2 = clusterer.clusterInstance(instance);
                stringBuffer.append(n + " " + n2 + " " + ClusterEvaluation.attributeValuesString(instance, range) + "\n");
            }
            catch (Exception exception) {
                stringBuffer.append(n + " Unclustered " + ClusterEvaluation.attributeValuesString(instance, range) + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String attributeValuesString(Instance instance, Range range) {
        StringBuffer stringBuffer = new StringBuffer();
        if (range != null) {
            boolean bl = true;
            range.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!range.isInRange(i)) continue;
                if (bl) {
                    stringBuffer.append("(");
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(instance.toString(i));
                bl = false;
            }
            if (!bl) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    private static String makeOptionString(Clusterer clusterer) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n\nGeneral options:\n\n");
        stringBuffer.append("-t <name of training file>\n");
        stringBuffer.append("\tSets training file.\n");
        stringBuffer.append("-T <name of test file>\n");
        stringBuffer.append("\tSets test file.\n");
        stringBuffer.append("-l <name of input file>\n");
        stringBuffer.append("\tSets model input file.\n");
        stringBuffer.append("-d <name of output file>\n");
        stringBuffer.append("\tSets model output file.\n");
        stringBuffer.append("-p <attribute range>\n");
        stringBuffer.append("\tOutput predictions. Predictions are for training file\n\tif only training file is specified,\n\totherwise predictions are for the test file.\n\tThe range specifies attribute values to be output\n\twith the predictions. Use '-p 0' for none.\n");
        stringBuffer.append("-x <number of folds>\n");
        stringBuffer.append("\tOnly Distribution Clusterers can be cross validated.\n");
        stringBuffer.append("-s <random number seed>\n");
        stringBuffer.append("\tSets the seed for randomizing the data in cross-validation\n");
        stringBuffer.append("-c <class index>\n");
        stringBuffer.append("\tSet class attribute. If supplied, class is ignored");
        stringBuffer.append("\n\tduring clustering but is used in a classes to");
        stringBuffer.append("\n\tclusters evaluation.\n");
        if (clusterer instanceof Drawable) {
            stringBuffer.append("-g <name of graph file>\n");
            stringBuffer.append("\tOutputs the graph representation of the clusterer to the file.\n");
        }
        if (clusterer instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + clusterer.getClass().getName() + ":\n\n");
            Enumeration enumeration = ((OptionHandler)((Object)clusterer)).listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        String string;
        int n;
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        ClusterEvaluation clusterEvaluation = (ClusterEvaluation)object;
        if (this.m_classToCluster != null != (clusterEvaluation.m_classToCluster != null)) {
            return false;
        }
        if (this.m_classToCluster != null) {
            for (n = 0; n < this.m_classToCluster.length; ++n) {
                if (this.m_classToCluster[n] == clusterEvaluation.m_classToCluster[n]) continue;
                return false;
            }
        }
        if (this.m_clusterAssignments != null != (clusterEvaluation.m_clusterAssignments != null)) {
            return false;
        }
        if (this.m_clusterAssignments != null) {
            for (n = 0; n < this.m_clusterAssignments.length; ++n) {
                if (this.m_clusterAssignments[n] == clusterEvaluation.m_clusterAssignments[n]) continue;
                return false;
            }
        }
        if (Double.isNaN(this.m_logL) != Double.isNaN(clusterEvaluation.m_logL)) {
            return false;
        }
        if (!Double.isNaN(this.m_logL) && this.m_logL != clusterEvaluation.m_logL) {
            return false;
        }
        if (this.m_numClusters != clusterEvaluation.m_numClusters) {
            return false;
        }
        String string2 = this.m_clusteringResults.toString().replaceAll("Elapsed time.*", "");
        return string2.equals(string = clusterEvaluation.m_clusteringResults.toString().replaceAll("Elapsed time.*", ""));
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the name of a clusterer");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            Clusterer clusterer = Clusterer.forName(string, null);
            System.out.println(ClusterEvaluation.evaluateClusterer(clusterer, stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

