package fr.iri.thd.sonyengine.web;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import thd.ThdEngine;

import com.sun.jersey.api.view.Viewable;

import fr.iri.thd.sonyengine.core.DataAccessor;
import fr.iri.thd.sonyengine.core.DbEnv;

@Path("status")
public class StatusResource {

	@GET
	@Produces(MediaType.TEXT_HTML)
	public Viewable info(@Context ServletContext context) {
		String dbpath = (String)context.getAttribute(ServletContainer.DB_PATH_ATTRIBUTE);
		
		final int segments_nb = ThdEngine.getEngine().getAllMovieFragments().size();
		
		final DbEnv dbenv = (DbEnv)context.getAttribute(ServletContainer.DB_ENV_ATTRIBUTE);		
		final DataAccessor da = new DataAccessor(dbenv.getEntityStore());
		final long segments_db_nb = da.movieFragmentById.count();
		final long tags_nb = da.tagById.count();
		
		
		final Map<String,Object> vars = new HashMap<String, Object>();
		
		vars.put("dbpath", dbpath);
		vars.put("segments_nb", segments_nb);
		vars.put("segments_db_nb", segments_db_nb);
		vars.put("tags_nb", tags_nb);
		
		
		Viewable view = new Viewable("/status", vars);
				
		return view;
	}
	
}
