package fr.iri.thd.sonyengine;

import java.io.File;

import javax.servlet.ServletException;
import javax.ws.rs.core.Application;

import thd.ThdEngine;

import com.sleepycat.persist.EntityCursor;

public class ServletContainer extends
		com.sun.jersey.spi.container.servlet.ServletContainer {

	/**
	 * 
	 */
	private static final long serialVersionUID = -447765110849619632L;

	public static final String DB_ENV_ATTRIBUTE = "DB_ENV";
	
	public ServletContainer() {
	}

	public ServletContainer(Class<? extends Application> appClass) {
		super(appClass);
	}

	public ServletContainer(Application app) {
		super(app);
	}


	public void init() throws ServletException {
		super.init();
		
		String databasePath = this.getInitParameter("initDatabasePath");
		
		if(databasePath == null)
			return;

		File databasePathFile = new File(databasePath);
		
		if(!databasePathFile.exists())
		{
			databasePathFile.mkdirs();
		}
		DbEnv env = new DbEnv();
		env.setup(databasePathFile, false);
		
		// set DbEnv in servlet context
		this.getServletContext().setAttribute(ServletContainer.DB_ENV_ATTRIBUTE, env);
		
		//load all entities
		DataAccessor da = new DataAccessor(env.getEntityStore());
		
		EntityCursor<MovieFragment> movieFragmentItems = da.movieFragmentById.entities();
		
		try {
			for(MovieFragment item : movieFragmentItems) {
				ThdEngine.getEngine().createMovieFragment(item.getId());
			}
		}
		finally {
			movieFragmentItems.close();
		}
		
		EntityCursor<Tag> tagItems = da.tagById.entities();
		
		try {
			for(Tag item : tagItems) {
				ThdEngine.getEngine().addTag(item.getName(), item.getSegment());
			}
		}
		finally {
			tagItems.close();
		}
		
		ThdEngine.getEngine().reTrain();
	}
	
	public void destroy() {
		DbEnv env = (DbEnv)this.getServletContext().getAttribute(DB_ENV_ATTRIBUTE);
		
		if(env != null) {
			env.close();
		}
	}
	
}
