package csl.tools.parallel;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JProgressBar;

import csl.tools.gui.StatusBar;

public abstract class ForP<E, F> {

	private static final int DEFAUL_NUM_PROC = Runtime.getRuntime()
			.availableProcessors();
	protected static final int NUM = 10000;
	private static final int NONE = 0;
	private static final int PAUSED = 1;
	private static final int RUNNING = 2;
	private static final int STOPPED = 3;
	private List<E> items;
	private int numProc = DEFAUL_NUM_PROC;
	public Object[] result;
	private List<ForPThread<E, F>> threads = new Vector<ForPThread<E, F>>();
	private List<ForPThread<E, F>> terminated = new Vector<ForPThread<E, F>>();
	private int counter = 0;
	private final int size;
	public boolean done = false;
	private JProgressBar progressBar;
	private boolean showProgress = false;
	private boolean showActivity = false;
	private JFrame progressFrame;
	final private String myName;
	private ForPActivityPane activityPane;
	private JFrame activityFrame;
	public boolean killOnErr = true;
	private StatusBar statusBar;
	private int status = NONE;

	public ForP(String name, List<E> items) {

		this.myName = name;
		this.items = items;
		this.result = new Object[items.size()];
		this.size = items.size();
		if (showActivity)
			showActivity(100, 100);
	}

	public ForP(String name, List<E> items, int procCount) {

		this(name, items);
		this.numProc = procCount;
	}

	public void setKillOnErr(boolean b) {

		killOnErr = b;
	}

	public boolean getKillOnErr() {

		return killOnErr;
	}

	private void done() {

		done = true;
		hideProgress();
		hideActivity();
	}

	public void done(E item, ForPThread<E, F> subth) {

		if (!showProgress)
			return;
		synchronized (progressBar) {

			getProgressBar().setValue(getProgressBar().getValue() + 1);
		}
	}

	public void done(ForPThread<E, F> th) {

		synchronized (terminated) {
			terminated.add(th);
			if (terminated.size() == threads.size())
				done();
		}
	}

	private JProgressBar getProgressBar() {

		if (progressBar == null) {
			progressBar = new JProgressBar();
			progressBar.setMinimum(0);
			progressBar.setMaximum(size);
			progressBar.setValue(0);
		}
		return progressBar;
	}

	private ForPActivityPane getActivityPane() {

		if (activityPane == null) {
			activityPane = new ForPActivityPane();
		}
		return activityPane;
	}

	private JFrame getProgressFrame() {

		if (progressFrame == null) {
			progressFrame = new JFrame("Progress...");
			progressFrame.setSize(750, 60);
			progressFrame.setAlwaysOnTop(true);
		}
		return progressFrame;
	}

	private JFrame getActivityFrame() {

		if (activityFrame == null) {
			activityFrame = new JFrame("Activity...");
			activityFrame.setSize(300, 400);
			activityFrame.setLocation(800, 200);
			activityFrame.setContentPane(getActivityPane());
			activityFrame.setAlwaysOnTop(true);
		}
		return activityFrame;
	}

	private void hideProgress() {

		if (!showProgress)
			return;
		showProgress = false;
		getProgressFrame().setVisible(false);
		progressFrame = null;
	}

	private void hideActivity() {

		if (!showActivity)
			return;
		showActivity = false;
		getActivityFrame().setVisible(false);
		activityFrame = null;
	}

	public boolean isDone() {

		return done;
	}

	public E nextItem() {

		synchronized (items) {
			if (counter >= size)
				return null;
			final E toto = items.get(counter++);
			return toto;
		}
	}

	@SuppressWarnings("unchecked")
	public List<F> process() {

		createThreads();
		runThreads();
		return (List<F>) Arrays.asList(result);
	}

	@SuppressWarnings("unchecked")
	public List<F> processAndWait() {

		createThreads();
		runThreads();
		List<F> res = (List<F>) Arrays.asList(result);
		waitDone();
		return res;
	}

	public void waitDone() {

		while (!done) {
			try {
				Thread.sleep(20);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	public ForPThread<E, F> createThread(final String name) {

		return new ForPThread<E, F>(name, this) {

			private void done() {

				setDone();
				ForP.this.done(this);
			}

			@Override
			public void run() {

				E item;
				while ((!father.done) && ((item = father.nextItem()) != null)) {
					if (isPaused())
						waitForResume();
					if (isStopped())
						break;
					try {
						printStatus("Doing: " + item);
						father.result[father.indexFor(item)] = father.process(
								item, this);
					} catch (Exception e) {
						System.err.println("\nThread " + name + " met error");
						e.printStackTrace();
						if (killOnErr) {
							System.err.println("Kill " + name);
							done();
						} else {
							System.err.println("Thread " + name + " goes on");
						}
					} catch (OutOfMemoryError e) {

						System.err.println("\nThread " + name + " met error");
						e.printStackTrace();
						if (killOnErr) {
							System.err.println("Kill " + name);
							;
							done();
						}
					}
					ForP.this.done(item, this);
				}
				done();
			}
		};
	}

	protected void waitForResume() {

		while (isPaused())
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
	}

	public boolean pauseMe() {

		if (!isRunning())
			return false;
		status = PAUSED;
		return true;
	}

	public boolean stopMe() {

		if (!isRunning() && !isPaused())
			return false;
		status = STOPPED;
		return true;
	}

	public boolean resumeMe() {

		if (!isPaused())
			return false;
		status = RUNNING;
		return true;
	}

	protected boolean isStopped() {

		return status == STOPPED;
	}

	protected boolean isPaused() {

		return status == PAUSED;
	}

	protected boolean isRunning() {

		return status == RUNNING;
	}

	protected void printStatus(String string) {

		if (statusBar == null)
			return;
		statusBar.newPermanentMessage(string);
	}

	public synchronized int indexFor(E item) {

		return items.indexOf(item);
	}

	private void createThreads() {

		for (int i = 0; i < numProc; i++) {
			ForPThread<E, F> th;
			threads.add(th = createThread(myName + " -> th" + i));
			if (showActivity && th != null)
				th.setActivityPane(getActivityPane());
		}
	}

	private void runThreads() {

		for (ForPThread<E, F> th : threads)
			th.start(showActivity);
	}

	abstract public F process(E item, ForPThread<E, F> thread) throws Exception;

	public void showProgress(String title) {

		showProgress = true;
		getProgressBar().setMinimum(0);
		getProgressBar().setMaximum(size);
		getProgressBar().setValue(0);
		getProgressFrame().getContentPane().add(getProgressBar());
		getProgressFrame().setTitle(title);
		getProgressFrame().setVisible(true);
	}

	public void showProgressOn(JProgressBar bar) {

		progressBar = bar;
		getProgressBar().setMinimum(0);
		getProgressBar().setMaximum(size);
		getProgressBar().setValue(0);
		hideProgress();
		showProgress = true;
	}

	public void showActivity(int i, int j) {

		showActivity = true;
		getActivityFrame().setContentPane(getActivityPane());
		getActivityFrame().setSize(380, 100 * (1 + (numProc / 4)));
		getActivityFrame().setLocation(i, j);
		getActivityFrame().setVisible(true);

	}

	@Override
	public String toString() {

		return "Th: " + myName;
	}

	public void showStatusOn(StatusBar statusBar) {

		this.statusBar = statusBar;
	}

	/**
	 * Workaround to simulate while, use this list with a ForP
	 * 
	 * @param i
	 * @return
	 */
	public static List<Integer> list(int count) {

		List<Integer> list = new Vector<Integer>(count);
		for (int i = 0; i < count; i++)
			list.add(i);
		return list;
	}

	public int getThreadIndex(ForPThread<E, F> th) {

		return threads.indexOf(th);
	}
}
