package csl.tools.profiling;

import java.awt.GridLayout;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

import csl.tools.files.FileTools;

public class MemoryStats extends JPanel {

	private static final long serialVersionUID = -1635131477444994829L;

	private JTextField usedTextField = null;

	private JTextField freeTextField = null;

	private JTextField totalTextField = null;

	private JTextField maxTextField = null;

	private DecimalFormat df = new DecimalFormat("#,###,###,###,###.##");

	private PrintWriter pw = FileTools.printWriterOn(new File("C:\\MEM.CSV"));

	private static String state;

	public MemoryStats() {

		super();
		initialize();
	}

	private void initialize() {

		GridLayout gridLayout = new GridLayout();
		gridLayout.setRows(1);
		this.setLayout(gridLayout);
		this.setSize(200, 65);
		this.add(getUsedTextField(), null);
		this.add(getFreeTextField(), null);
		this.add(getTotalTextField(), null);
		this.add(getMaxTextField(), null);
	}

	private JTextField getUsedTextField() {

		if (usedTextField == null) {
			usedTextField = new JTextField();
			usedTextField.setEditable(false);
		}
		return usedTextField;
	}

	private JTextField getFreeTextField() {

		if (freeTextField == null) {
			freeTextField = new JTextField();
			freeTextField.setEditable(false);
		}
		return freeTextField;
	}

	private JTextField getTotalTextField() {

		if (totalTextField == null) {
			totalTextField = new JTextField();
			totalTextField.setEditable(false);
		}
		return totalTextField;
	}

	private JTextField getMaxTextField() {

		if (maxTextField == null) {
			maxTextField = new JTextField();
			maxTextField.setEditable(false);
		}
		return maxTextField;
	}

	public void updateStats() {

		final String used = format(usedMem());
		getUsedTextField().setText(used);
		final String free = format(freeMem());
		getFreeTextField().setText(free);
		final String total = format(totalMem());
		getTotalTextField().setText(total);
		final String max = format(maxMem());
		getMaxTextField().setText(max);
		log(state + "," + used + "," + free + "," + total + "," + max);
	}

	private synchronized void log(String string) {

		pw.append(string).append("\n");
		pw.flush();
	}

	private String format(long l) {
		return "" + (l / (1024 * 1024));
	}

	private long usedMem() {
		return totalMem() - freeMem();
	}

	private long maxMem() {
		return Runtime.getRuntime().maxMemory();
	}

	private long totalMem() {
		return Runtime.getRuntime().totalMemory();
	}

	private long freeMem() {
		return Runtime.getRuntime().freeMemory();
	}

	public void start() {

		JFrame fr = new JFrame("Memory stats");
		Runnable r = new Runnable() {

			public void run() {

				while (true) {
					updateStats();
					try {
						Thread.sleep(300);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
		};
		new Thread(r).start();
		fr.setContentPane(this);
		fr.setLocation(850, 100);
		fr.setSize(250, 70);
		fr.setVisible(true);
	}

	public static void setState(String string) {
		state = string;
	}

}
