/*
 * Decompiled with CFR 0.152.
 */
package thd;

import java.io.File;
import thd.Neighbor;
import thd.ThdEngine;
import thd.ThdMovieFragment;

public class ThdEngineTest {
    public static void main(String[] args) {
        ThdEngineTest.testSimpleExampleManual();
        ThdEngineTest.testSimpleExampleFile();
    }

    private static void testSimpleExampleManual() {
        System.out.println("testSimpleExampleManual");
        ThdEngineTest.setUpSimpleExample();
        ThdEngine engine = ThdEngine.getEngine();
        engine.reTrain();
        ThdEngineTest.showNeighborsUntilNoBetter("ref1", "enfant", 0.05f, true);
    }

    private static void setUpSimpleExample() {
        ThdEngine engine = ThdEngine.getEngine();
        engine.clearAll();
        engine.createMovieFragments("ref1", "ref2", "ref3", "ref4", "ref5", "ref6", "ref7");
        engine.addTags(new String[]{"crayon", "carte", "bateau", "voiture", "car"}, "ref1");
        engine.addTags(new String[]{"enfant", "famille", "violon", "maison", "hopital"}, "ref2");
        engine.addTags(new String[]{"enfant", "famille", "violon", "maison", "ordinateur", "fenetre", "voiture", "guitare", "carte"}, "ref3");
        engine.addTags(new String[]{"enfant", "famille", "violon", "bateau", "ordinateur", "fenetre", "stylo", "perroquet", "crayon", "tele", "bateau"}, "ref4");
        engine.addTags(new String[]{"ordinateur", "crayon", "fenetre", "hopital", "carte", "tele", "stylo", "perroquet", "bateau", "guitare"}, "ref5");
        engine.addTags(new String[]{"maison", "perroquet", "stylo", "guitare", "hopital", "tele", "car", "voiture", "fenetre"}, "ref6");
        engine.addTags(new String[]{"car", "voiture"}, "ref7");
    }

    public static void testSimpleExampleFile() {
        System.out.println("testSimpleExampleFile");
        ThdEngine engine = ThdEngine.getEngine();
        engine.clearAll();
        engine.loadFromTextFile(new File("./Sessions/Essai.csv"));
        System.out.println("number of movies read: " + engine.getAllMovieFragments().size());
        engine.reTrain();
        ThdEngineTest.showNeighborsUntilNoBetter("ref1", "enfant", 0.05f, true);
    }

    public static void testUniversCineFile() {
        ThdEngine engine = ThdEngine.getEngine();
        engine.loadFromTextFile(new File("./Sessions/MovieFrame2.csv"));
        System.out.println("number of movies read: " + engine.getAllMovieFragments().size());
        ThdMovieFragment sobibor = engine.movieFragmentNamed("Sobibor, 14 octobre 1943, 16 heures");
        engine.reTrain();
        ThdEngineTest.showNeighborsUntilNoBetter(sobibor.getName(), "Enfant", 0.05f, true);
    }

    public static void showNeighborsUntilNoBetter(String startRef, String tagRef, float percent, boolean moreOrLess) {
        ThdEngine engine = ThdEngine.getEngine();
        Neighbor neighbor = engine.findMore(startRef, tagRef, percent, moreOrLess);
        while (neighbor != null) {
            System.out.println(neighbor.toString());
            neighbor = engine.findMore(neighbor.getMovieRef(), tagRef, percent, moreOrLess);
        }
        System.out.println("cannot find any better");
    }
}

