"""add label and uuid

Revision ID: 3aec56269d7e
Revises: 37eaf74e46b
Create Date: 2014-10-28 17:17:19.017259

"""

# revision identifiers, used by Alembic.
revision = '3aec56269d7e'
down_revision = '37eaf74e46b'

import uuid

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.add_column('event_session', sa.Column('label', sa.String(length=2048), nullable=True))
    op.add_column('event_session', sa.Column('uuid', postgresql.UUID(), nullable=True))
    op.create_unique_constraint(None, 'event_session', ['uuid'])
    event_session = sa.sql.table('event_session',
        sa.sql.column('id', sa.Integer),
        sa.sql.column('uuid', postgresql.UUID)
    )
    connection = op.get_bind()
    for r in connection.execute(event_session.select()):
        op.execute(event_session.update().values({'uuid':str(uuid.uuid4())}).where(event_session.c.id == r['id']))
    op.alter_column('event_session', 'uuid',
           existing_type=postgresql.UUID(),
           nullable=False)



def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("event_session_uuid_key", 'event_session')
    op.drop_column('event_session', 'uuid')
    op.drop_column('event_session', 'label')
    ### end Alembic commands ###
