/**
* js/annotsRoll.js
*
* annotsRoll basic component
*
*/

'use strict';

var PIXI = require('pixi');
var randomColor = require('randomColor');

function AnnotsRoll(parentContainer, xInit, yInit, width, height, widthRoll, pixelsPerSecond, annotColors, lineInterval){
    var _this = this;
    this.container = new PIXI.DisplayObjectContainer();
    this.container.position.x = xInit;
    this.container.position.y = yInit;
    this.container.width = width;
    parentContainer.addChild(this.container);

    this.height = height;
    this.width = width;
    this.widthRoll = widthRoll;
    this.pixelsPerSecond = pixelsPerSecond;
    this.lineInterval = lineInterval;

    this.addAnnot = function(category, user, catColor){
    	var graphics = new PIXI.Graphics();
    	var color = catColor;
    	var x = 0;
    	var y = -this.container.y;
        graphics.beginFill(color);
        graphics.drawRect(x, y, 10, 3);
        graphics.endFill();
        
        this.container.addChild(graphics);

        var catText = new PIXI.Text(category, { font: '16pt Arial', fill: '#65A954' });
        catText.x = x + 20;
        catText.y = y - 23;
        this.container.addChild(catText);
        
        var userText = new PIXI.Text(user, { font: '10pt Arial', fill: '#444444' });
        userText.x = x + 20;
        userText.y = y + 2;
        this.container.addChild(userText);
        
        this.addAnnotLine(color)
    };

    this.addAnnotLine = function(color){
    	var x = this.widthRoll;
    	var y = -this.container.y;
    	
    	var graphics = new PIXI.Graphics();
    	
        graphics.beginFill(color);
        graphics.drawRect(x, y, this.width - x, 3);
        graphics.endFill();
        
        this.container.addChild(graphics);
    };

    this.moveTo = function(diffTime){
    	this.container.y = Math.floor(diffTime*this.pixelsPerSecond);
    };

    this.removePassedObjets = function(){
        var nbChilds = _this.container.children.length;
        var i = 0, childIsNowDisplayed = false, childrenToRemove = [];
        while(i<nbChilds && !childIsNowDisplayed){
            var child = _this.container.children[i++];
            
            if(typeof(child) == 'undefined') {
                continue;
            }
        	if((child.y + child.height) < (Math.abs(_this.container.y) - _this.height)){
                childrenToRemove.push(child);
            }
            else {
                childIsNowDisplayed = true;
            }
        }
        childrenToRemove.forEach(function(child) {
            _this.container.removeChild(child);
        });
    };

	window.setInterval(this.removePassedObjets, 1000 * this.height / this.pixelsPerSecond );

}

module.exports = AnnotsRoll;
