/**
 * scripts/main.js
 *
 * This is the starting point for your application.
 * Take a look at http://browserify.org/ for more info
 */

'use strict';


var PIXI = require('pixi');

// Config vars
var logger = false;
var sceneWidth = 1920;
var prHeight1 = 435;
var prHeight2 = 645;
var sceneHeight = prHeight1 + prHeight2;
var sceneBgColor = 0xFFFFFF;
var lineColor = 0x444444;
var pixelsPerSecond1 = Math.floor(sceneWidth / 10); // nb of pixels per second
var manualFramerate = pixelsPerSecond1 / 4;
var pixelsPerSecond2 = Math.floor(sceneWidth / 60); // nb of pixels per second
var lineInterval = 5000; // means line every 5 seconds
var nbLines = -1;
var noteHeight = 110;
var noteColors = [0xB90000, 0x4BDD71, 0xAF931E, 0x1C28BA, 0x536991];
var colorsReg = {};
// Vars
var noteDict = [];
// Timecode method
var timePageLoaded = Date.now();
var offsetMusic = false;


//create an new instance of a pixi stage
var stage = new PIXI.Stage(sceneBgColor);

//create a renderer instance.
var renderer = PIXI.autoDetectRenderer(sceneWidth, sceneHeight);

//add the renderer view element to the DOM
document.getElementById('canvasContainer').appendChild(renderer.view);

var uberContainer = new PIXI.DisplayObjectContainer();
uberContainer.position.x = Math.floor(sceneWidth*9/10);
uberContainer.position.y = 0;
stage.addChild(uberContainer);

var PianoRoll = require('./pianoroll.js')

// Init containers
var containerList = [];
containerList.push(new PianoRoll(uberContainer, 0, 0, prHeight1, true, pixelsPerSecond1, sceneWidth, noteColors, colorsReg, lineColor, lineInterval, offsetMusic, prHeight1 / 128));
containerList.push(new PianoRoll(uberContainer, 0, prHeight1, prHeight2, false, pixelsPerSecond2, sceneWidth, noteColors, colorsReg, lineColor, lineInterval, offsetMusic, prHeight2 / 128));

// Line between two containers
var graphics = new PIXI.Graphics();
graphics.beginFill(0xFFFF00);
graphics.lineStyle(1, lineColor);
graphics.moveTo(0, prHeight1);
graphics.lineTo(sceneWidth, prHeight1);
graphics.endFill();
stage.addChild(graphics);


function replaceContainers(){
    var diff = (Date.now() - timePageLoaded)/1000;// nb of seconds since page loaded
    //console.log("replace ! diff1 = ", container1.x - Math.floor(-diff*pixelsPerSecond1), ", diff 2 = ", container2.x - Math.floor(-diff*pixelsPerSecond2));
    for(var i=0;i<containerList.length;i++){
        containerList[i].moveTo(-diff);
    }
    renderer.render(stage);
}

function addNotes(data){
    if(!offsetMusic){
        // get difference between the current note timecode and my zero to set the difference between the canvas's zero and the music's zero
        // in order to place in real time
        var now = Date.now();
        var timeBetweenNowAndStart = now - timePageLoaded;
        offsetMusic = timeBetweenNowAndStart - data.content[1];
        //console.log("start: ", timePageLoaded, ", now: ", now, ", timeBetweenNowAndStart = ", timeBetweenNowAndStart, ", offsetMusic = ", offsetMusic);
    }
    var note = data.content[3];
    var velocity = data.content[4];
    if(velocity===0){
        if(typeof noteDict[data.content[2]][note]!=='undefined'){
            // We close the note in container one
            //console.log("coucou 2", data);
            var duration = data.content[1] - noteDict[data.content[2]][note].ts;
            for(var i=0;i<containerList.length;i++){
                //               addNote(note, startTime,                          duration, velocity,                                 canal)
                containerList[i].addNote(note, noteDict[data.content[2]][note].ts, duration, noteDict[data.content[2]][note].velocity, data.content[2]);
            }
            // delete entry
            delete noteDict[data.content[2]][note];
        }
    }
    else{
        if(typeof noteDict[data.content[2]]==='undefined'){
            noteDict[data.content[2]] = {};
        }
        noteDict[data.content[2]][note] = {ts: data.content[1], velocity:velocity};
    }
}

function addLine(){
    ts = new Date();
    for(var i=0;i<containerList.length;i++){
        containerList[i].addLine(ts);
    }
}



// Socket management
var sock = null;
var ellog = null;
function log(m) {
    if(logger){
        ellog.innerHTML += m + '\n';
        ellog.scrollTop = ellog.scrollHeight;
    }
}
window.onload = function(){

    if(logger){
        ellog = document.getElementById('log');
    }
    else{
        document.body.removeChild(document.getElementById('log'));
    }

    var wsuri;
    if (window.location.protocol === 'file:') {
        wsuri = 'ws://127.0.0.1:8090/broadcast';
    } else {
        wsuri = 'ws://' + window.location.hostname + ':8090/broadcast';
    }
    wsuri = wsuri + '?channel=PIANOROLL&event_code='+eventCode;

    if ('WebSocket' in window) {
        sock = new WebSocket(wsuri);
    } else if ('MozWebSocket' in window) {
        sock = new MozWebSocket(wsuri);
    } else {
        log('Browser does not support WebSocket!');
        window.location = 'http://autobahn.ws/unsupportedbrowser';
    }

    if (sock) {
        sock.onopen = function(){
            if(logger){
                log('Connected to ' + wsuri);
            }
        };

        sock.onclose = function(e) {
            if(logger){
                log('Connection closed (wasClean = ' + e.wasClean + ', code = ' + e.code + ', reason = \'' + e.reason + '\')');
            }
            sock = null;
        };

        sock.onmessage = function(e) {
            if(logger){
                log('Got message: ' + e.data);
            }
            addNotes(JSON.parse(e.data));
        };
    }
};


// Init page and intervals
addLine();
var moveInterval = window.setInterval(replaceContainers, 1000/manualFramerate);
var verticalLinesInterval = window.setInterval(addLine, lineInterval);

// Little inteval to show time
var nbSec = 0;
var mySpan = document.getElementById('myspan');
function updateTime(){
    nbSec++;
    var hours = parseInt( nbSec / 3600 ) % 24;
    var minutes = parseInt( nbSec / 60 ) % 60;
    var seconds = nbSec % 60;
    var timeStr = (hours < 10 ? '0' + hours : hours) + ':' + (minutes < 10 ? '0' + minutes : minutes) + ':' + (seconds  < 10 ? '0' + seconds : seconds);
    mySpan.innerHTML = timeStr;
}
var secondInterval = window.setInterval(updateTime, 1000);

module.exports = {
    moveInterval: moveInterval,
    verticalLinesInterval: verticalLinesInterval,
    secondInterval: secondInterval
};
