
#
# See LICENCE for detail
# Copyright (c) 2014 IRI
#

import psycopg2.extras

from twisted.python import log

from txpostgres.txpostgres import Connection, ConnectionPool


PIANOROLL_CHANNEL = 'PIANOROLL'
ANNOTATION_CHANNEL = 'ANNOT'

class DictConnection(Connection):

    @staticmethod
    def connectionFactory(*args, **kwargs):
        kwargs['connection_factory'] = psycopg2.extras.DictConnection
        return psycopg2.connect(*args, **kwargs)


class DictConnectionPool(ConnectionPool):
    connectionFactory = DictConnection


def create_connection_pool(conn_string):

    created_connection_pool = DictConnectionPool(None, conn_string)

    d = created_connection_pool.start()
    d.addErrback(log.err)

    return created_connection_pool, d
