
#
# See LICENCE for detail
# Copyright (c) 2014 IRI
#

import sys

import psycopg2.extras

from twisted.application import service
from twisted.python import log
from txpostgres import txpostgres

from annotserver import make_service
from models import get_table_create_stmt
from utils import create_connection_pool

#postgresql://[user[:password]@][netloc][:port][/dbname][?param1=value1&...]

psycopg2.extras.register_uuid()


config = {
    'web_port': 8080,
    'ws_port': 8090,
    'osc_port': 9090,
    'conn_str': 'postgresql://iri:iri@localhost:5432/annotations'
}


conn, d = create_connection_pool(config['conn_str'])
#to do treat error
d.addCallback(lambda _: conn.runOperation(get_table_create_stmt()))

#TOODO Log
#log.startLogging(sys.stdout)


application = service.Application("annot-server")

annotserver = make_service(config, conn)
annotserver.setServiceParent(service.IServiceCollection(application))
