/**
* js/utils.js
*
* basic tools
*
*/

'use strict';

function formatTime (ts) {
	var hours = Math.floor( (ts/1000) / 3600 ) % 24;
	var minutes = Math.floor( (ts/1000) / 60 ) % 60;
	var seconds = Math.floor( (ts/1000) % 60);
	return ((hours < 10 ? '0' + hours : hours) + ':' + (minutes < 10 ? '0' + minutes : minutes) + ':' + (seconds  < 10 ? '0' + seconds : seconds));
}

function getAnnotCategories(urlCategories, annotCategories) {

    var jsonLoader = new PIXI.JsonLoader(urlCategories, true);
    
    jsonLoader.on('loaded', function(res) {
        var data = res.target.json;

        while(annotCategories.length > 0) {
        	annotCategories.pop();
        }

        data.sessions.forEach(function(session) {
            var annotCat = {
                ts: session.start_ts === null ? new Date(0) : Date.parse(session.start_ts),
                colors: {}
            }
            var categoriesJson = session.categories_json;
            annotCat.order = categoriesJson.order;
            categoriesJson.categories.forEach(function(cat) {
                annotCat.colors[cat.code] = colorToHex(cat.color);
            });
            annotCat.defaultColor = categoriesJson.defaultColor || "#536991";
            annotCategories.push(annotCat);
        });
        console.log(annotCategories);
        annotCategories[0].order.push("default");
    });
    
    jsonLoader.load();
    
}

module.exports = {
	formatTime: formatTime,
	getAnnotCategories: getAnnotCategories
};
