"""use index shortcuts

Revision ID: 37eaf74e46b
Revises: 3c78152eb874
Create Date: 2014-10-28 16:41:05.519404

"""

# revision identifiers, used by Alembic.
revision = '37eaf74e46b'
down_revision = '3c78152eb874'

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_index(op.f('ix_annotation_channel'), 'annotation', ['channel'], unique=False)
    op.create_index(op.f('ix_annotation_event_code'), 'annotation', ['event_code'], unique=False)
    op.create_index(op.f('ix_annotation_ts'), 'annotation', ['ts'], unique=False)
    op.drop_index('idx_annotation_channel', table_name='annotation')
    op.drop_index('idx_annotation_event', table_name='annotation')
    op.drop_index('idx_annotation_ts', table_name='annotation')
    op.create_index(op.f('ix_event_active'), 'event', ['active'], unique=False)
    op.create_index(op.f('ix_event_code'), 'event', ['code'], unique=True)
    op.create_index(op.f('ix_event_start_date'), 'event', ['start_date'], unique=False)
    op.drop_index('idx_event_active', table_name='event')
    op.drop_index('idx_event_code', table_name='event')
    op.drop_index('idx_event_start_date', table_name='event')
    op.create_index(op.f('ix_event_session_order'), 'event_session', ['order'], unique=False)
    op.create_index(op.f('ix_event_session_start_ts'), 'event_session', ['start_ts'], unique=False)
    op.drop_index('idx_event_session_order', table_name='event_session')
    op.drop_index('idx_event_session_start_ts', table_name='event_session')


def downgrade():
    op.create_index('idx_event_session_start_ts', 'event_session', ['start_ts'], unique=False)
    op.create_index('idx_event_session_order', 'event_session', ['order'], unique=False)
    op.drop_index(op.f('ix_event_session_start_ts'), table_name='event_session')
    op.drop_index(op.f('ix_event_session_order'), table_name='event_session')
    op.create_index('idx_event_start_date', 'event', ['start_date'], unique=False)
    op.create_index('idx_event_code', 'event', ['code'], unique=False)
    op.create_index('idx_event_active', 'event', ['active'], unique=False)
    op.drop_index(op.f('ix_event_start_date'), table_name='event')
    op.drop_index(op.f('ix_event_code'), table_name='event')
    op.drop_index(op.f('ix_event_active'), table_name='event')
    op.create_index('idx_annotation_ts', 'annotation', ['ts'], unique=False)
    op.create_index('idx_annotation_event', 'annotation', ['event_code'], unique=False)
    op.create_index('idx_annotation_channel', 'annotation', ['channel'], unique=False)
    op.drop_index(op.f('ix_annotation_ts'), table_name='annotation')
    op.drop_index(op.f('ix_annotation_event_code'), table_name='annotation')
    op.drop_index(op.f('ix_annotation_channel'), table_name='annotation')
