###############################################################################
# #
# #  Copyright (C) 2011-2014 Tavendo GmbH
# #
# #  Licensed under the Apache License, Version 2.0 (the "License");
# #  you may not use this file except in compliance with the License.
# #  You may obtain a copy of the License at
# #
# #      http://www.apache.org/licenses/LICENSE-2.0
# #
# #  Unless required by applicable law or agreed to in writing, software
# #  distributed under the License is distributed on an "AS IS" BASIS,
# #  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# #  See the License for the specific language governing permissions and
# #  limitations under the License.
# #
###############################################################################

import sys
import csv
import time
    
from twisted.python import log
from twisted.internet import reactor
import argparse


from autobahn.twisted.websocket import WebSocketClientProtocol, WebSocketClientFactory

class MyClientProtocol(WebSocketClientProtocol):

    #def __init__(self, rows):

    def onConnect(self, response):
        print("Server connected: {0}".format(response.peer))
        reactor.callLater(0, self.send_messages)

    def onOpen(self):
        print("WebSocket connection open.")

    def send_messages(self):
        with open("annotsroll_sample_formated.txt", 'rU') as datafile:
            for row in list(datafile):
                self.sendMessage(row, isBinary = False)
                time.sleep(0.1)
            
        #time.sleep(0.1)
        #self.sendMessage('{"user":"Julien"}'.encode('utf8'))
        print("Goodbye")
        self.factory.reactor.callLater(0.1, reactor.stop)

    def onClose(self, wasClean, code, reason):
        print("WebSocket connection closed: {0}".format(reason))



if __name__ == '__main__':
    
    log.startLogging(sys.stdout)
    
    parser = argparse.ArgumentParser(description='Simulate an (osc) pianoroll client.')
    #parser.add_argument('datafile', metavar='DATAFILE', help='The file containing the pianoroll data (CSV).')
    parser.add_argument('-e', '--event', dest='event', metavar='EVENT', required=True, help='the event code.')
    
    args = parser.parse_args()
    
    #with open(args.datafile, 'rU') as datafile:
    #    reader = csv.reader(datafile, delimiter=' ')
    
    factory = WebSocketClientFactory("ws://127.0.0.1:8090/annot?event=%s" % args.event, debug=True)
    factory.protocol = MyClientProtocol
    
    reactor.connectTCP("127.0.0.1", 8090, factory)
    reactor.run()
    