/**
* js/annotsRoll.js
*
* annotsRoll basic component
*
*/

'use strict';

var PIXI = require('pixi');
var _ = require('lodash');

//
//
//
// options = {
//     parentContainer:,
//     externalRefresh: true/false
//     ws:,
//     xInit:,
//     yInit:,
//     width:,
//     height:,
//     widthRoll:,
//     pixelsPerSecond:,
//     framerate:,
//     annotColors: [{ts: , colors: {code1 : '#dshdsj', code2: 'sdasd', 'default': 'dsadas'}}],
//     defaultColor: default,
//     annotStyles: {
//         'label': {font:, fill:},
//         'text':{font:, fill:},
//         'user':{font:, fill:},
//     }
// }
var DEFAULT_ANNOT_COLOR = '#bababa';

var defaultAnnotStyles = {
    'label': { font: '26pt Arial Bold', fill: '#65A954' },
    'text' : { font: '20pt Arial Regular', fill: '#444444' },
    'user' : { font: '22pt Arial regular', fill: '#444444' },
};

var defaultOptions = {
    externalRefresh: false,
    defaultColor: DEFAULT_ANNOT_COLOR,
    annotStyles: defaultAnnotStyles
};

function AnnotsRoll(options) {

//parentContainer, xInit, yInit, width, height, widthRoll, pixelsPerSecond, annotColors
    var _this = this;
    var opts = _(options).defaults(defaultOptions).value();


    this.container = new PIXI.DisplayObjectContainer();
    this.container.x = opts.xInit;
    this.container.y = opts.yInit;
    this.container.width = opts.width;

    this.height = opts.height;
    this.width = opts.width;
    this.widthRoll = opts.widthRoll;
    this.pixelsPerSecond = opts.pixelsPerSecond;
    this.annotColors = opts.annotColors;
    this.startTs = options.startTs || Date.now();

    var yInit = opts.yInit;
    var annotStyles = _(opts.annotStyles).defaults(defaultAnnotStyles).value();
    var started = false;
    var ws = opts.ws;
    var externalRefresh = opts.externalRefresh;
    var stageView = opts.stageView;
    
    stageView.registerComponent(this);

    var isHidden = function(child) {
        // TODO: the origin point is an approximation. Should refine this
        var globalPos = child.toGlobal(new PIXI.Point(0,0));
        return ((globalPos.x + child.width) < 0) || ((globalPos.y + child.height) < 0) ;
    };

    this.addAnnots = function(data) {

        //var title = data.content.category.label;
        //var user = data.content.user;
        //Test cat and color
        //var colorAnnot = 0x65A954;
        var category = data.content.category.label,
            text     = data.content.text,
            user     = data.content.user,
            ts       = Date.parse(data.ts),
            color    = this.getColor(ts, data.content.category.code);

        this.addAnnot(category, text, user, color, ts);
    };

    this.getColor = function(ts, code) {
        var colorsDef;
        _(this.annotColors).eachRight(function(cdef) {
            console.log("cDef", cdef);
            console.log("cDef ts", cdef.ts, ts);
            if(cdef.ts < ts) {
                colorsDef = cdef.colors;
                return false;
            }
        });
        var resColor;
        console.log("colorsDef", colorsDef);
        if(colorsDef) {
            resColor = colorsDef[code];
        }
        if(!resColor) {
            resColor = DEFAULT_ANNOT_COLOR;
        }
        return resColor;
    }

    this.addAnnot = function(category, text, user, catColor, ts){

        var color = catColor ? catColor : DEFAULT_ANNOT_COLOR;
        var x = 0;
        var y = (ts-this.startTs) * this.pixelsPerSecond / 1000 + yInit;

        var colorHex = parseInt(color.replace(/^#/, ''), 16);

        var graphics = new PIXI.Graphics()
            .beginFill(colorHex)
            .drawRect(x, y, 10, 3)
            .endFill();

        this.container.addChild(graphics);

        var catLabel = new PIXI.Text(
            category,
            _(annotStyles.label).extend({fill: color}).value()
        );
        catLabel.x = x + 20;
        catLabel.y = y - 23;
        this.container.addChild(catLabel);

        var textHeight = 0;
        if(text) {
            var catText = new PIXI.Text(text, annotStyles.text);
            catText.x = x + 20;
            catText.y = y + 2;
            this.container.addChild(catText);
            textHeight += (catText.height + 2);
        }

        var catUser = new PIXI.Text(user, annotStyles.user);
        catUser.x = x + 20;
        catUser.y = y + 2 + textHeight;
        this.container.addChild(catUser);

        this.addAnnotLine(colorHex, y);
    };

    this.addAnnotLine = function(color, y) {
        var x = this.widthRoll;


        var graphics = new PIXI.Graphics()
            .beginFill(color)
            .drawRect(x, y, this.width - x, 3)
            .endFill();

        this.container.addChild(graphics);
    };

    this.moveTo = function(diffTime){
    	this.container.y = Math.floor(diffTime*this.pixelsPerSecond);
    };

    this.move = this.refresh = function() {
        var diff = (this.startTs - Date.now())/1000;
        this.moveTo(diff);
    };

    this.removePassedObjets = function(){
        var childrenToRemove = [];
        _(_this.container.children).forEach(function(child) {
            return typeof(child) === 'undefined' ||
                (isHidden(child) && childrenToRemove.push(child));
        });
        childrenToRemove.forEach(function(child) {
            _this.container.removeChild(child);
        });
    };

    this.init = function() {

        ws.message(function(data) {
            _this.addAnnots(data);
        });

    };

    this.start = function() {
        if(!started) {
            this.startTs = Date.now();
            started = true;
        }
        this.cleanInterval = setInterval(function () { _this.removePassedObjets(); }, 1000 * this.height / this.pixelsPerSecond );
        if(!externalRefresh) {
            this.refreshInterval = setInterval(function() {_this.move();}, 1000/this.framerate);
        }
    };

    this.stop = function() {
        clearInterval(this.cleanInterval);
        if(!externalRefresh) {
            clearInterval(this.refreshInterval);
        }
    };

}

module.exports = {
    AnnotsRoll: AnnotsRoll,
};
