#
# See LICENCE for detail
# Copyright (c) 2014 IRI
#

import sys

import flask.ext.restless

import database
import models
from webapp import app

manager = flask.ext.restless.APIManager(app, session=database.db_session)

manager.create_api(models.Annotation,
    methods=['GET', 'POST', 'PUT', 'DELETE'],
    url_prefix='/api/v1',
    primary_key='uuid',
    max_results_per_page=sys.maxint)

manager.create_api(models.EventSession,
    methods=['GET'],
    url_prefix='/api/v1',
    primary_key='uuid',
    max_results_per_page=sys.maxint)

manager.create_api(models.Event,
    methods=['GET'],
    url_prefix='/api/v1',
    primary_key='code',
    max_results_per_page=sys.maxint)
