#!/usr/bin/env python

import codecs
import sys
import dateutil.parser
from datetime import date, datetime, time
from dateutil.tz import tzlocal
import pytz

if __name__ == "__main__":

    file_log = codecs.open(sys.argv[1], 'r', "UTF-16LE")
    start_time = ""
    duration = None
    start_stat = False
    for line in file_log:
        if "Session Started" in line:
             start_time = dateutil.parser.parse(":".join(line.split(":")[:-1]).strip()).replace(tzinfo=tzlocal())
             start_time_utc = start_time.astimezone(pytz.utc)
        if "Encoding Statistics" in line:
            start_stat = True
        if start_stat and line.startswith("Video"):
            duration = dateutil.parser.parse(line.split()[2]) - datetime.combine(date.today(), time())

        if start_stat and duration:
            print("Start time local: " + start_time.isoformat())
            print("Start time UTC  : " + start_time_utc.isoformat())
            if duration:
                print("Duration  : " + str(duration) + " - " + str(int(duration.total_seconds())) + " s - " + str(int(duration.total_seconds())*1000) + " ms")
            duration = None
            start_stat = False


