(function(){
    'use strict';

    angular.module('mons', [ 'ngResource', 'ngRoute', 'autocomplete' ])
        .config(function($routeProvider) {
            $routeProvider.
                when('/', {
                    controller: 'homeCtrl'
               }).
               otherwise({
                   redirectTo: '/'
               });
        })
        .config(function($logProvider){
            $logProvider.debugEnabled(true);
        })
        .service('dataApi', function($resource, context) {
            console.log('dataApi',$resource, context);
            this.dataResource = $resource(context.urls.dataUrl);
        })
        .service('dataModel', function(dataApi) {
            //console.log('dataModel',this,dataApi);
            this.data = dataApi.dataResource.get();
        })
        .controller('homeCtrl', function($scope, $location, dataModel, context, $interval){
            //console.log('homeCtrl 1', $scope, $location, context);
            console.log('homeCtrl 2', context);
            $scope.data = dataModel.data;
            
            dataModel.data.$promise.then(function(data) {
                if(typeof data.categories!=='undefined' && data.categories.length>0){
                    var cats = [];
                    var nbCat = data.categories.length;
                    for(var i=0;i<nbCat;i++){
                        cats.push(data.categories[i].label);
                        if(typeof data.categories[i].subcategories!=='undefined' && data.categories[i].subcategories.length>0){
                            var nbSubCat = data.categories[i].subcategories.length;
                            for(var j=0;j<nbSubCat;j++){
                                cats.push(data.categories[i].subcategories[j].label);
                            }
                        }
                    }
                    $scope.allCatLabels = cats;
                }
            });
            
            $scope.selectedlevel = false;

            $scope.currentInterval = false;
            $scope.showSuccessAlert = false;
            $scope.showAlertDiv = false;
            function showAlert(m, success){
                $scope.alertMessage = m;
                $scope.showSuccessAlert = success;
                $scope.showAlertDiv = true;
                if(!$scope.$$phase) {
                    $scope.$apply();
                }
                if($scope.currentInterval){
                    $interval.cancel($scope.currentInterval);
                    $scope.currentInterval = false;
                }
                $scope.currentInterval = $interval(function(){ console.log('fin interval !'); $interval.cancel($scope.currentInterval); $scope.showAlertDiv = false; }, 2000, 1);
            }
            
            

            // Socket management
            var sock = null;
            var ellog = null;
            
            ellog = document.getElementById('log');
            function log(m) {
                if(ellog){
                    ellog.innerHTML += m + '\n';
                    ellog.scrollTop = ellog.scrollHeight;
                }
            }

            var wsuri;
            if (window.location.protocol === 'file:') {
                wsuri = 'ws://127.0.0.1:8090/annot';
            } else {
                wsuri = 'ws://' + window.location.hostname + ':8090/annot';
            }
            wsuri = wsuri + '?event=test';

            if ('WebSocket' in window) {
                sock = new WebSocket(wsuri);
            } else if ('MozWebSocket' in window) {
                sock = new window.MozWebSocket(wsuri);
            } else {
                if(context.logging===true){
                    log('Browser does not support WebSocket!');
                }
                window.location = 'http://autobahn.ws/unsupportedbrowser';
            }
            
            if (sock) {
                sock.onopen = function() {
                    if(context.logging===true){
                        log('Connected to ' + wsuri);
                    }
                };

                sock.onclose = function(e) {
                    if(context.logging===true){
                        log('Connection closed (wasClean = ' + e.wasClean + ', code = ' + e.code + ', reason = ' + e.reason + ')');
                    }
                    showAlert('Communication interrompue : la socket vient de se fermer.', false);
                    sock = null;
                };

                sock.onmessage = function(e) {
                    if(context.logging===true){
                        log('Got message: ' + e.data);
                    }
                    showAlert('Annotation bien reçue.', true);
                };
            }

            $scope.sendAnnotation = function(eventCode){
                if($scope.username==='' || typeof $scope.username==='undefined'){
                    showAlert('Vous devez indiquer un nom d\'utilisateur.', false);
                    return;
                }
                if(eventCode==='' || typeof eventCode==='undefined'){
                    showAlert('Vous devez indiquer un nom de catégorie.', false);
                    return;
                }
                // Send query
                if (sock) {
                    var new_annot = {
                            categories : eventCode,
                            user : $scope.username
                    };
                    sock.send(JSON.stringify(new_annot));
                    if(context.logging===true){
                        log('Sent: ' + JSON.stringify(new_annot));
                    }
                } else {
                    showAlert('La socket ne fonctionne pas.', false);
                    if(context.logging===true){
                        log('Not connected.');
                    }
                }
            };
            
            // Interface management
            $scope.selectLevel = function(i, eventCode){
                if(i===false){
                    $scope.returnVisStyle = {visibility:'hidden'};
                    $scope.selectedlevel = false;
                    return;
                }
                if(typeof $scope.data.categories[i].subcategories!=='undefined' && $scope.data.categories[i].subcategories.length>0){
                    $scope.selectedlevel = $scope.data.categories[i].subcategories;
                    $scope.returnVisStyle = {visibility:'show'};
                }
                else{
                    // Send query
                    $scope.sendAnnotation(eventCode);
                }
            };
            
        });

})();
