"""First migration

Revision ID: 3c78152eb874
Revises: None
Create Date: 2014-10-28 15:24:25.401385

"""

# revision identifiers, used by Alembic.
revision = '3c78152eb874'
down_revision = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('event',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('code', sa.String(length=255), nullable=False),
    sa.Column('label', sa.String(length=2048), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('start_date', sa.DateTime(), nullable=True),
    sa.Column('active', sa.Boolean(), server_default='1', nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_event_active'), 'event', ['active'], unique=False)
    op.create_index(op.f('ix_event_code'), 'event', ['code'], unique=True)
    op.create_index(op.f('ix_event_start_date'), 'event', ['start_date'], unique=False)
    op.create_table('event_session',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('event_id', sa.Integer(), nullable=False),
    sa.Column('project_id', sa.String(length=2048), nullable=True),
    sa.Column('order', sa.Integer(), nullable=False),
    sa.Column('start_ts', sa.DateTime(timezone=True), nullable=True),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('categories_json', postgresql.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['event_id'], [u'event.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_event_session_order'), 'event_session', ['order'], unique=False)
    op.create_index(op.f('ix_event_session_start_ts'), 'event_session', ['start_ts'], unique=False)
    op.create_table('annotation',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', postgresql.UUID(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text("(now() at time zone 'utc')"), nullable=False),
    sa.Column('ts', sa.DateTime(timezone=True), nullable=False),
    sa.Column('event_code', sa.String(length=255), nullable=False),
    sa.Column('channel', sa.String(length=255), nullable=False),
    sa.Column('content', postgresql.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['event_code'], ['event.code'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uuid')
    )
    op.create_index(op.f('ix_annotation_channel'), 'annotation', ['channel'], unique=False)
    op.create_index(op.f('ix_annotation_event_code'), 'annotation', ['event_code'], unique=False)
    op.create_index(op.f('ix_annotation_ts'), 'annotation', ['ts'], unique=False)


def downgrade():
    op.drop_index(op.f('ix_annotation_ts'), table_name='annotation')
    op.drop_index(op.f('ix_annotation_event_code'), table_name='annotation')
    op.drop_index(op.f('ix_annotation_channel'), table_name='annotation')
    op.drop_table('annotation')
    op.drop_index(op.f('ix_event_session_start_ts'), table_name='event_session')
    op.drop_index(op.f('ix_event_session_order'), table_name='event_session')
    op.drop_table('event_session')
    op.drop_index(op.f('ix_event_start_date'), table_name='event')
    op.drop_index(op.f('ix_event_code'), table_name='event')
    op.drop_index(op.f('ix_event_active'), table_name='event')
    op.drop_table('event')
