/**
* js/generalView
*
* generalView basic component
*
*/

'use strict';

var PIXI = require('pixi');
var randomColor = require('randomColor');

function GeneralView(parentContainer, xInit, yInit, width, height, timeBegin, timeEnd, intervalSize){
	console.log(width);
    var _this = this;
    this.container = new PIXI.DisplayObjectContainer();
    this.container.position.x = xInit;
    this.container.position.y = yInit;
    this.container.width = width;
    this.container.height = height;
    parentContainer.addChild(this.container);
    
    this.timeBegin = timeBegin;
    this.timeEnd = timeEnd;
    this.duration = (timeEnd - timeBegin)/1000 
    this.width = width;
    this.height = height;
    //define interval corresponding to the time of one step
    //e.g: 60 for a step of 60 seconds
    this.intervalSize = intervalSize;
    // define the step depending the interval we passed and the duration
    this.intervalDuration = (intervalSize*this.duration/width);
    
  //Initialise the list of step
    //each cell will contain the list categories and the number of annotations per categories
    this.cells = []
    
    
    // draw temp line to locate the middle of the container
    var graphics = new PIXI.Graphics();
    graphics.beginFill(0x000000);
    graphics.lineStyle(1, 0x000000);
    graphics.moveTo(xInit, (-this.height/2) );
    graphics.lineTo(this.width, (-this.height/2));
    graphics.endFill();
    this.container.addChild(graphics);

    this.addAnnot = function(category, time){
    	var x = Math.floor( (time-this.timeBegin)/(1000*this.intervalDuration)) * this.intervalSize;
    	var y = (-this.height/2);
    	
    	//Check if cell is already set.
    	//If yes get increment the numbere of annots in the category corresponding
    	//If not initialise the cell
//    	if (this.cells[x] === "undefined"){
//    		cells[x].push({
//    			"code" : category.code,
//    			"color" : category.color,
//    			"count" : 1
//    		});
//    	} else {
//    		if (c)
//    	} 
    	
    	console.log("x : " + x + " | y : " + y);
        
    	// We draw the rectangle
        var graphics = new PIXI.Graphics();
        graphics.beginFill(0x536991);
        graphics.drawRect(x, y, this.intervalSize, -10);
        graphics.endFill();
        
        this.container.addChild(graphics);
    };

}

module.exports = GeneralView;
