'use strict';

var config = require('../config');
var p = require('../../package.json')
var gulp = require('gulp');
// var prefix = require('gulp-autoprefixer');
var csso = require('gulp-csso');
var less = require('gulp-less');
var rename = require('gulp-rename');
var size = require('gulp-size');
var fs = require('fs')

// Styles
gulp.task('styles', function () {
  return gulp.src('app/less/app.less')
    // Leaving out recess support due to string interpolation missing in less v1.3 (which recess is dependent on)
    // .pipe(recess())
    .pipe(less({
      style: 'expanded',
      loadPath: [config.bower]
    }))
    .pipe(rename(p.name+'.css'))
    .pipe(gulp.dest(config.dist + '/css'))
    .pipe(size());
});


// Styles Dist
gulp.task('styles:dist', function () {

  return gulp.src('app/less/app.less')
    // Leaving out recess support due to string interpolation missing in less v1.3 (which recess is dependent on)
    // .pipe(recess())
    .pipe(less({
      style: 'expanded',
      loadPath: [config.bower]
    }))
    // .pipe(prefix('last 1 version'))  // add vendor prefixes if necessary
    .pipe(rename(p.name+'.min.css'))
    .pipe(csso())  // minify css
    .pipe(gulp.dest(config.dist + '/css'))
    .pipe(size());
});
