
#
# See LICENCE for detail
# Copyright (c) 2014 IRI
#

import datetime
import json
import uuid

def get_table_create_stmt():
    return (
        "CREATE TABLE IF NOT EXISTS annotations ( "
        "id serial PRIMARY KEY, "
        "uuid uuid UNIQUE, "
        "created timestamp default (now() at time zone 'utc') NOT NULL, "
        "ts timestamptz NOT NULL, "
        "event varchar(255) NOT NULL, "
        "channel varchar(255) NOT NULL, "
        "content json);"
    )

def insert_annot_async(params, conn):

    content = params.get('content', {})
    if not isinstance(content, basestring):
        params['content'] = json.dumps(content)
    if 'uuid' not in params:
        params['uuid'] = uuid.uuid4()

    if 'ts' not in params:
        params['ts'] = datetime.utcnow()

    defer = conn.runOperation("INSERT INTO annotations (uuid, ts, event, channel, content) VALUES (%(uuid)s, %(ts)s, %(event)s, %(channel)s, %(content)s)", params)
    defer.addCallback(lambda _: params)

    return defer
