'use strict';

var browserify = require('browserify');
var config = require('../config');
var partialify = require('partialify');
var gulp = require('gulp');
var debug = require('gulp-debug');
var rename = require('gulp-rename');
var source = require('vinyl-source-stream');
var p = require('../../package.json')
var uglify = require('gulp-uglify');

// Vendor
gulp.task('vendor', function() {
  return browserify({debug: true})
    .require('./app/lib/pixi/bin/pixi.js', { expose: 'pixi' })
    .require('./app/lib/randomColor/randomColor.js', {expose: 'randomColor'})
    .bundle()
    .pipe(source('libs-'+p.name+'.js'))
    .pipe(gulp.dest(config.dist + '/js/'));
});

// Browserify
gulp.task('browserify', function() {
  return browserify({debug: true, standalone: 'annotviz'})
    .add('./app/js/main.js')
    .external('pixi')
    .external('randomColor')
    .transform(partialify) // Transform to allow requireing of templates
    .bundle()
    .pipe(source(p.name+'.js'))
    .pipe(gulp.dest(config.dist + '/js/'));
});

// Script Dist
gulp.task('scripts:dist', function() {
  return gulp.src([config.dist + '/js/*.js', '!'+config.dist + '/js/*.min.js'], {base: config.dist})
    .pipe(uglify())
    .pipe(rename({extname: '.min.js'}))
    .pipe(gulp.dest(config.dist));
});
