/**
* js/generalView
*
* generalView basic component
*
*/

'use strict';

var PIXI = require('pixi');
var randomColor = require('randomColor');
var rgb2hex = require('./utils');

function GeneralView(parentContainer, xInit, yInit, width, height, timeBegin, timeEnd, intervalWidth, intervalHeight, maxCellHeight, categories){
    var _this = this;
    this.container = new PIXI.DisplayObjectContainer();
    this.container.position.x = xInit;
    this.container.position.y = yInit;
    this.container.width = width;
    this.container.height = height;
    parentContainer.addChild(this.container);
    
    this.timeBegin = timeBegin;
    this.timeEnd = timeEnd;
    this.duration = (timeEnd - timeBegin)/1000 
    this.width = width;
    this.height = height;
    this.intervalHeight = intervalHeight;
    this.intervalWidth = intervalWidth;
    this.maxCellHeight = maxCellHeight;
    this.intervalDuration = (intervalWidth*this.duration/width);
    
    
    //Initialise the list of step
    //each cell will contain the list categories and the number of annotations per categories
    this.cells = []
    for (var i=0; i<(width/intervalWidth) ; i++){
    	this.cells[i] = [];
    	this.cells[i].x = i * this.intervalWidth;
    	this.cells[i].totalAnnots = 0;
    	this.cells[i].graphics = new PIXI.Graphics();
    	this.container.addChild(this.cells[i].graphics);
    	this.cells[i].categories = {};
    	
    	for (var category in categories){
    		this.cells[i].categories[category] = {
				"count": 0,
				"color": categories[category]
    		};
    	}
    }
    // draw temp line to locate the middle of the container
    var graphics = new PIXI.Graphics();
    graphics.beginFill(0x000000)
    	.lineStyle(1, 0x000000)
    	.moveTo(xInit, (-this.height/2) )
    	.lineTo(this.width, (-this.height/2))
    	.endFill();
    this.container.addChild(graphics);

    //Add Annotation to the TimeLine
    this.addAnnot = function(category, time){
    	console.log(this.timeEnd);
    	console.log(time);
    	if (this.timeEnd < time){
    		return;
    	}
    	var i = Math.floor((time-this.timeBegin)/(1000*this.intervalDuration));
		this.cells[i].categories[category].count += 1;
		this.cells[i].totalAnnots +=1;
		this.redrawCell(this.cells[i]);
    };
    
    //Draw the cellule
    this.redrawCell = function(cell){
    	var x = cell.x; 
    	var y = -this.height/2;
    	cell.graphics.clear();
    	
    	//Check if total height is higher than Max Cell Height
    	if ((cell.totalAnnots*this.intervalHeight) > this.maxCellHeight){
    		var heightStep = this.maxCellHeight/cell.totalAnnots;
    	} else {
    		var heightStep = this.intervalHeight;
    	}
    	//Draw the rect depending on the height step calculated
    	for (var category in cell.categories){
			cell.graphics.beginFill(cell.categories[category].color)
    			.drawRect(x, y, this.intervalWidth, -cell.categories[category].count * heightStep)
    			.endFill();
    		y -= cell.categories[category].count*heightStep;
    	}
    }
}

module.exports = GeneralView;
