#
# See LICENCE for detail
# Copyright (c) 2014 IRI
#

import json

from flask import render_template, jsonify, request, abort
from jinja2 import Markup
from sqlalchemy.orm import joinedload

from webapp import app
from database import db_session
import models

@app.route('/')
def page_home():
    return render_template('index.html')
    #return render_template('annotationclient.html', logging=True)


@app.route('/annot')
def page_annot():
    return render_template('annot.html')


@app.route('/annotationclient')
def page_annotationclient():
    return render_template('annotationclient.html', logging=True)

@app.route('/annotationclient/<event_code>')
def page_annotationclient_event_code(event_code):
    #TODO: check event code + get event session
    event_query = db_session.query(models.Event).filter(models.Event.code==event_code)
    event = event_query.one()
    if not event:
        abort(404)

    #TODO: See why the relationship management does not work
    event_session_q = db_session.query(models.EventSession).filter(models.EventSession.event_id==event.id).order_by(models.EventSession.order.desc())
    event_session = event_session_q.first()

    categories_json = None

    if event_session:
        categories_json = event_session.categories_json

    if not categories_json:
        categories_json = None

    return render_template('annotationclient.html',
        logging = True,
        event_code = event_code,
        categories_json = Markup(json.dumps(categories_json).replace('\'','\\\'')) if categories_json else None
    )


@app.route('/pianoroll')
def page_pianoroll():
    return render_template('pianoroll.html', logging=True)


@app.route('/api/test', methods=['PUT', 'POST'])
def new():
    return jsonify(request.get_json(force=False))
