/**
* js/annotsvizview.js
*
* This is the starting point for your application.
* Take a look at http://browserify.org/ for more info
*
*/
/*jshint unused: false */

'use strict';

var PIXI = require('pixi');
var _ = require('lodash');
var DoubleRoll = require('./doubleroll.js');
var AnnotsTimeLine = require('./annotstimeline.js');
var AnnotsRoll = require('./annotsroll.js');
var Utils = require('./utils.js');

var defaultOptions = {
    xInit: 0,
    yInit: 0,
    width: 1024,
    height: 768
};

function AnnotsVizView(options){
    var _this = this;
    var opts = _(options).defaults(defaultOptions).value();

    this.container = new PIXI.DisplayObjectContainer();
    this.container.x = opts.xInit;
    this.container.y = opts.yInit;
    this.width = opts.width;
    this.height= opts.height;
    this.timeBegin = opts.timeBegin;
    this.timeEnd = opts.timeEnd;

    this.annotCategories = [];
    this.annotCategoriesDay2 = [];
    this.annotCategoriesDay1 = [];

    var wsPianoroll = opts.wsPianoroll;
    var wsAnnot = opts.wsAnnot;
    var stageView = opts.stageView;
    var channel = opts.channel;
    var serverUrl = opts.serverUrl;

    var eventCode = opts.eventCode;
    var eventCodeSessionDay2 = opts.eventCodeSessionDay2;
	var eventCodeSessionDay1 = opts.eventCodeSessionDay1;
    var logger = opts.logger;

	Utils.getAnnotCategories(opts.urlCategories + eventCode, this.annotCategories);
    Utils.getAnnotCategories(opts.urlCategories + eventCodeSessionDay2, this.annotCategoriesDay2);
    Utils.getAnnotCategories(opts.urlCategories + eventCodeSessionDay1, this.annotCategoriesDay1);

    stageView.registerComponent(this);

    var currentDay = new AnnotsTimeLine.AnnotsTimeLine({
    	stageView : stageView,
        logger: logger,
        ws: wsAnnot,
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768-200,
        timeBegin: this.timeBegin,
        timeEnd: this.timeEnd,
        intervalWidth: 6,
        intervalHeight: 10,
        maxCellHeight: 70,
        radius: 200,
        eventCode: eventCode,
        channel: channel,
        serverUrl: serverUrl,
        annotCategories: this.annotCategories
    });

	//Archive day 2
    var timeLineDay2 = new AnnotsTimeLine.AnnotsTimeLine({
    	stageView : stageView,
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768-200,
        timeBegin: Date.parse('2015-01-23T09:30:00+01:00'),
        timeEnd: Date.parse('2015-01-23T18:30:00+01:00'),
        circleX: currentDay.circleX,
        circleY: currentDay.circleY,
        intervalWidth: (currentDay.radius*2/3)* currentDay.intervalWidth / currentDay.radius,
        intervalHeight: (currentDay.intervalHeight * (currentDay.radius - currentDay.radius*2/3))/ currentDay.maxCellHeight,
        maxCellHeight: (currentDay.radius - currentDay.radius*2/3)/2,
        radius: currentDay.radius*2/3,
        annotCategories: this.annotCategoriesDay2,
        eventCode: eventCodeSessionDay2,
        channel: channel,
        serverUrl: serverUrl,
        showClockGraphics:false,
        archive: true
    });

	//Archive day 1
    var timeLineDay1 = new AnnotsTimeLine.AnnotsTimeLine({
    	stageView : stageView,
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768-200,
        timeBegin: Date.parse('2015-01-22T09:30:00+01:00'),
        timeEnd: Date.parse('2015-01-22T18:30:00+01:00'),
        circleX: currentDay.circleX,
        circleY: currentDay.circleY,
        intervalWidth: (currentDay.radius*2/3)* currentDay.intervalWidth / currentDay.radius,
        intervalHeight: (currentDay.intervalHeight * (currentDay.radius - currentDay.radius/3))/ currentDay.maxCellHeight,
        maxCellHeight: (currentDay.radius*2/3 - currentDay.radius/3)/4,
        radius: currentDay.radius/3,
        annotCategories: this.annotCategoriesDay1,
        eventCode: eventCodeSessionDay1,
        channel: channel,
        serverUrl: serverUrl,
        showClockGraphics:false,
        archive: true,
    });

    var currentTimeText = new PIXI.Text('-- : -- : --', { font: '18pt Gothic Standard', fill: '#646464' });
    currentTimeText.x = timeLineDay2.circleX - currentTimeText.width/2;
    currentTimeText.y = timeLineDay2.circleY - currentTimeText.height/2;
    this.container.addChild(currentTimeText);


    var doubleRollH = new DoubleRoll.DoubleRoll({
        stageView : stageView,
        logger: logger,
        ws: wsPianoroll,
        yInit: (this.height - 200),
        sceneHeight: 200,
        pianorolls : [
            {
                height: 200,
                timeWidth: 10,
                lineInterval: 5000,
                noteHeight: 10
            },
        ]
    });

    var doubleRollV = new DoubleRoll.DoubleRoll({
        stageView : stageView,
        logger: logger,
        ws: wsPianoroll,
        orientation: 'vertical',
        sceneHeight: 768-200,
        pianorolls : [
            {
                height: 200,
                timeWidth: 60,
                lineInterval: 5000,
                noteHeight: 5,
            },
        ]
    });

    var annotsRoll = new AnnotsRoll.AnnotsRoll({
        stageView : stageView,
        logger: logger,
        ws: wsAnnot,
        parentContainer: doubleRollV.stage,
        xInit: 1024 - 200 - 200,
        yInit: 768-200,
        width: 200 + 200,
        height: 768-200,
        widthRoll: 200,
        framerate: doubleRollV.framerate,
        pixelsPerSecond: Math.floor(1024 / 60),
        annotColors: this.annotCategories
    });

    var limiters = new PIXI.Graphics()
        .lineStyle(1, 0x646464)
        .moveTo(annotsRoll.container.x, annotsRoll.container.y)
        .lineTo(annotsRoll.container.x, annotsRoll.container.y - annotsRoll.height)
        .moveTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y)
        .lineTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y - annotsRoll.height)
        .moveTo(0, this.height - 200)
        .lineTo(this.width, this.height - 200)
        .drawRect(0, 0, this.width -1, this.height -1)
        .beginFill(0xECECEC)
        .drawRect(1024 - 200, 0, 200, 768-200)
        .endFill();
    this.container.addChild(limiters);

    this.init = function(){
    };

    this.updateTime = function(){
        currentTimeText.setText(Utils.formatTime(Date.now()));
    };

    var refreshTimeInterval;

    this.start = function() {
        refreshTimeInterval = setInterval(function() {_this.updateTime();}, 1000);
    };

    this.refresh = function() {
    };

    this.stop = function(){
    };

    return this;

}

module.exports = {
    AnnotsVizView: AnnotsVizView
};
